package tocraft.walkers.mixin;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1400;
import net.minecraft.class_1493;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.registry.WalkersEntityTags;

@SuppressWarnings({})
@Mixin(class_1493.class)
public abstract class WolfEntityMixin extends class_1321 {

    private WolfEntityMixin(class_1299<? extends class_1321> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Unique
    private static final class_2940<Boolean> walkers$isSpecial = class_2945.method_12791(class_1493.class,
            class_2943.field_13323);

    @Inject(method = "registerGoals", at = @At("RETURN"))
    private void addPlayerTarget(CallbackInfo ci) {
        this.field_6185.method_6277(7,
                new class_1400<>(this, class_1657.class, 10, false, false, player -> {
                    // ensure wolves can attack players with a shape similar to their normal prey
                    if (!Walkers.CONFIG.wolvesAttack2ndShapedPrey) {
                        return false;
                    }

                    class_1309 shape = PlayerShape.getCurrentShape((class_1657) player);

                    // wolves should ignore players that look like their prey if they have an owner,
                    // unless the config option is turned to true
                    class_1309 owner = this.method_35057();
                    if (owner != null || Walkers.CONFIG.ownedWolvesAttack2ndShapedPrey) {
                        return false;
                    }

                    return shape != null && shape.method_5864().method_20210(WalkersEntityTags.WOLF_PREY);
                }));
    }

    @SuppressWarnings("ConstantConditions")
    @Inject(method = "tick", at = @At("HEAD"))
    public void onTick(CallbackInfo ci) {
        if (this.method_16914() && this.method_5797().getString().equalsIgnoreCase("Patreon"))
            ((class_1493) (Object) this).method_5841().method_12778(walkers$isSpecial, true);
        else
            ((class_1493) (Object) this).method_5841().method_12778(walkers$isSpecial, false);
    }

    @Inject(method = "defineSynchedData", at = @At("RETURN"))
    protected void onInitDataTracker(CallbackInfo ci) {
        ((class_1493) (Object) this).method_5841().method_12784(walkers$isSpecial, false);
    }

    @Inject(method = "addAdditionalSaveData", at = @At("RETURN"))
    protected void onWriteCustomDataToNbt(class_2487 nbt, CallbackInfo ci) {
        nbt.method_10556("isSpecial", ((class_1493) (Object) this).method_5841().method_12789(walkers$isSpecial));
    }

    @Inject(method = "readAdditionalSaveData", at = @At("RETURN"))
    protected void onReadCustomDataFromNbt(class_2487 nbt, CallbackInfo ci) {
        ((class_1493) (Object) this).method_5841().method_12778(walkers$isSpecial, nbt.method_10577("isSpecial"));
    }
}
