package tocraft.walkers.mixin;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1584;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(class_1584.class)
public abstract class RavagerEntityMixin extends class_1309 {

    private RavagerEntityMixin(class_1299<? extends class_1309> entityType, class_1937 world) {
        super(entityType, world);
    }

    // todo: move to inject
    @Override
    public void method_6091(class_243 movementInput) {
        if (method_5805()) {

            // Ensure Ravager has a passenger
            if (method_5782()) {
                class_1309 rider = (class_1309) method_31483();

                // Only players should be able to control Ravager
                if (rider instanceof class_1657) {
                    // Assign rider properties to ravager
                    this.method_36456(rider.method_36454());
                    this.field_5982 = this.method_36454();
                    this.method_36457(rider.method_36455() * 0.5F);
                    this.method_5710(this.method_36454(), this.method_36455());
                    this.field_6283 = this.method_36454();
                    this.field_6241 = this.field_6283;
                    float sidewaysSpeed = rider.field_6212 * 0.5F;
                    float forwardSpeed = rider.field_6250;

                    // Going backwards, slow down!
                    if (forwardSpeed <= 0.0F) {
                        forwardSpeed *= 0.25F;
                    }

                    // Update movement/velocity
                    if (this.method_5787()) {
                        this.method_6125((float) this.method_26825(class_5134.field_23719));
                        super.method_6091(new class_243(sidewaysSpeed, movementInput.field_1351, forwardSpeed));
                    } else if (rider instanceof class_1657) {
                        this.method_18799(class_243.field_1353);
                    }

                    // Limb updates for movement
                    this.method_29242(false);
                    return;
                }
            }
            // Doesn't have a passenger, or passenger is not player,
            // but still alive, fall back to default travel logic
            super.method_6091(movementInput);
        }
    }
}
