package tocraft.walkers.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1439;
import net.minecraft.class_1454;
import net.minecraft.class_1584;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_4019;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4466;
import net.minecraft.class_5134;
import net.minecraft.class_7260;
import net.minecraft.world.entity.*;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.mixin.accessor.*;
import tocraft.walkers.registry.WalkersEntityTags;

@SuppressWarnings("ConstantConditions")
@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends LivingEntityMixin {

    @Shadow
    public abstract boolean method_7325();

    @Shadow
    public abstract @NotNull class_4048 method_18377(class_4050 pose);

    @Shadow
    public abstract boolean method_5681();

    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "getDimensions", at = @At("HEAD"), cancellable = true)
    private void getDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        class_1309 entity = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (entity != null) {
            cir.setReturnValue(entity.method_18377(pose));
        }
    }

    /**
     * When a player turns into an Aquatic shape, they lose breath outside water.
     *
     * @param ci mixin callback info
     */
    @Inject(method = "tick", at = @At("HEAD"))
    private void tickAquaticBreathingOutsideWater(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape != null) {
            if (Walkers.isAquatic(shape)) {
                int air = this.method_5669();

                // copy of WaterCreatureEntity#tickWaterBreathingAir
                if (this.method_5805() && !this.method_5816()) {
                    int i = class_1890.method_8211((class_1309) (Object) this);

                    // If the player has respiration, 50% chance to not consume air
                    if (i > 0) {
                        if (field_5974.method_43048(i + 1) <= 0) {
                            this.method_5855(air - 1);
                        }
                    }

                    // No respiration, decrease air as normal
                    else {
                        this.method_5855(air - 1);
                    }

                    // Air has run out, start drowning
                    if (this.method_5669() == -20) {
                        this.method_5855(0);
                        this.method_5643(method_48923().method_48827(), 2.0F);
                    }
                } else {
                    this.method_5855(air + 1);
                }
            }
        }
    }

    @Inject(method = "getStandingEyeHeight", at = @At("HEAD"), cancellable = true)
    private void shape_getStandingEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        // cursed
        try {
            class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

            if (shape != null) {
                cir.setReturnValue(
                        ((LivingEntityAccessor) shape).callGetEyeHeight(method_18376(), method_18377(method_18376())));
            }
        } catch (Exception ignored) {

        }
    }

    @Environment(EnvType.CLIENT)
    @Override
    public float method_18381(class_4050 pose) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape != null) {
            return shape.method_18381(pose);
        } else {
            return this.method_18378(pose, this.method_18377(pose));
        }
    }

    @Inject(method = "getHurtSound", at = @At("HEAD"), cancellable = true)
    private void getHurtSound(class_1282 source, CallbackInfoReturnable<class_3414> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue(((LivingEntityAccessor) shape).callGetHurtSound(source));
        }
    }

    // todo: separate mixin for ambient sounds
    @Unique
    private int shape_ambientSoundChance = 0;

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickAmbientSounds(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (!field_6002.field_9236 && Walkers.CONFIG.playAmbientSounds && shape instanceof class_1308 mobShape) {

            if (this.method_5805() && this.field_5974.method_43048(1000) < this.shape_ambientSoundChance++) {
                // reset sound delay
                this.shape_ambientSoundChance = -mobShape.method_5970();

                // play ambient sound
                class_3414 sound = ((MobEntityAccessor) mobShape).callGetAmbientSound();
                if (sound != null) {
                    float volume = ((LivingEntityAccessor) mobShape).callGetSoundVolume();
                    float pitch = ((LivingEntityAccessor) mobShape).callGetVoicePitch();

                    // By default, players can not hear their own ambient noises.
                    // This is because ambient noises can be very annoying.
                    if (Walkers.CONFIG.hearSelfAmbient) {
                        this.field_6002.method_43128(null, this.method_23317(), this.method_23318(), this.method_23321(), sound,
                                this.method_5634(), volume, pitch);
                    } else {
                        this.field_6002.method_43128((class_1657) (Object) this, this.method_23317(), this.method_23318(), this.method_23321(), sound,
                                this.method_5634(), volume, pitch);
                    }
                }
            }
        }
    }

    @Inject(method = "getDeathSound", at = @At("HEAD"), cancellable = true)
    private void getDeathSound(CallbackInfoReturnable<class_3414> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue(((LivingEntityAccessor) shape).callGetDeathSound());
        }
    }

    @Inject(method = "getFallSounds", at = @At("HEAD"), cancellable = true)
    private void getFallSounds(CallbackInfoReturnable<class_1309.class_6823> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue(shape.method_39760());
        }
    }

    @Inject(method = "attack", at = @At("HEAD"))
    protected void shape_tryAttack(class_1297 target, CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape instanceof class_1439 golem) {
            ((IronGolemEntityAccessor) golem).setAttackTicksLeft(10);
        } else if (shape instanceof class_7260 warden) {
            warden.field_38137.method_41322(field_6012);
        } else if (shape instanceof class_1584 ravager) {
            ((RavagerEntityAccessor) ravager).setAttackTick(10);
        } else if (shape instanceof class_1639 && target instanceof class_1309 livingTarget) {
            livingTarget.method_37222(new class_1293(class_1294.field_5920, 200), this);
        } else if (shape instanceof class_4466 bee && bee.method_29511() && target instanceof class_1309 livingTarget) {
            livingTarget.method_37222(new class_1293(class_1294.field_5899, 200), this);
        } else if (shape instanceof class_1454 pufferfish) {
            int i = pufferfish.method_6594();

            if (target instanceof class_1309 livingTarget) {
                if (livingTarget.method_5643(this.method_48923().method_48812((class_1657) (Object) this), (float) (1 + i))) {
                    livingTarget.method_37222(new class_1293(class_1294.field_5899, 60 * i, 0), (class_1657) (Object) this);
                    this.method_5783(class_3417.field_14848, 1.0F, 1.0F);

                    if (livingTarget instanceof class_3222 serverPlayerTarget && !this.method_5701()) {
                        serverPlayerTarget.field_13987.method_14364(new class_2668(class_2668.field_25654, 0.0F));
                    }
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickGolemAttackTicks(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape instanceof class_1439 golem) {
            IronGolemEntityAccessor accessor = (IronGolemEntityAccessor) golem;
            if (accessor.getAttackTicksLeft() > 0) {
                accessor.setAttackTicksLeft(accessor.getAttackTicksLeft() - 1);
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickRavagerAttackTicks(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape instanceof class_1584 ravager) {
            RavagerEntityAccessor accessor = (RavagerEntityAccessor) ravager;
            if (accessor.getAttackTick() > 0) {
                accessor.setAttackTick(accessor.getAttackTick() - 1);
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickWardenSneakingAnimation(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape instanceof class_7260 warden) {
            if (method_5715()) {
                if (!warden.field_38169.method_41327()) {
                    warden.field_38169.method_41322(field_6012);
                }
            } else {
                warden.field_38169.method_41325();
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickFire(CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        class_1309 shape = PlayerShape.getCurrentShape(player);

        if (!player.field_6002.field_9236 && !player.method_7337() && !player.method_7325()) {
            // check if the player is shape
            if (shape != null) {
                class_1299<?> type = shape.method_5864();

                // check if the player's current shape burns in sunlight
                if (type.method_20210(WalkersEntityTags.BURNS_IN_DAYLIGHT)) {
                    boolean bl = this.walkers$isInDaylight();
                    if (bl) {

                        // Can't burn in the rain
                        if (player.field_6002.method_8419()) {
                            return;
                        }

                        // check for helmets to negate burning
                        class_1799 itemStack = player.method_6118(class_1304.field_6169);
                        if (!itemStack.method_7960()) {
                            if (itemStack.method_7963()) {

                                // damage stack instead of burning player
                                itemStack.method_7974(itemStack.method_7919() + player.method_6051().method_43048(2));
                                if (itemStack.method_7919() >= itemStack.method_7936()) {
                                    player.method_20235(class_1304.field_6169);
                                    player.method_5673(class_1304.field_6169, class_1799.field_8037);
                                }
                            }

                            bl = false;
                        }

                        // set player on fire
                        if (bl) {
                            player.method_5639(8);
                        }
                    }
                }
            }
        }
    }

    @Unique
    private boolean walkers$isInDaylight() {
        if (field_6002.method_8530() && !field_6002.field_9236) {
            float brightnessAtEyes = method_5718();
            class_2338 daylightTestPosition = class_2338.method_49637(method_23317(), (double) Math.round(method_23318()), method_23321());

            // move test position up one block for boats
            if (method_5854() instanceof class_1690) {
                daylightTestPosition = daylightTestPosition.method_10084();
            }

            return brightnessAtEyes > 0.5F && field_5974.method_43057() * 30.0F < (brightnessAtEyes - 0.4F) * 2.0F
                    && field_6002.method_8311(daylightTestPosition);
        }

        return false;
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickTemperature(CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        class_1309 shape = PlayerShape.getCurrentShape(player);

        if (!player.method_7337() && !player.method_7325()) {
            // check if the player is shape
            if (shape != null) {
                class_1299<?> type = shape.method_5864();

                // damage player if they are a shape that gets hurt by high temps (e.g. snow
                // golem in nether)
                if (type.method_20210(WalkersEntityTags.HURT_BY_HIGH_TEMPERATURE)) {
                    class_1959 biome = field_6002.method_23753(method_24515()).comp_349();
                    if (!biome.method_33599(method_24515())) {
                        player.method_5643(field_6002.method_48963().method_48813(), 1.0f);
                    }
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickWalkers(CallbackInfo ci) {
        if (!field_6002.field_9236) {
            class_1657 player = (class_1657) (Object) this;
            class_1309 shape = PlayerShape.getCurrentShape(player);

            // assign basic data to entity from player on server; most data transferring
            // occurs on client
            if (shape != null) {
                shape.method_23327(player.method_23317(), player.method_23318(), player.method_23321());
                shape.method_5847(player.method_5791());
                shape.method_6100(((LivingEntityAccessor) player).isJumping());
                shape.method_5728(player.method_5624());
                shape.method_6097(player.method_6022());
                shape.method_5684(true);
                shape.method_5875(true);
                shape.method_5660(player.method_5715());
                shape.method_5796(player.method_5681());
                shape.method_6019(player.method_6058());
                shape.method_18380(player.method_18376());

                if (shape instanceof class_1321) {
                    ((class_1321) shape).method_6179(player.method_5715());
                    ((class_1321) shape).method_24346(player.method_5715());
                } else if (shape instanceof class_4019) {
                    ((class_4019) shape).method_18294(player.method_5715());
                    ((class_4019) shape).method_6100(!player.method_24828());
                }

                ((EntityAccessor) shape).shape_callSetFlag(7, player.method_6128());

                ((LivingEntityAccessor) shape).callUpdatingUsingItem();
                PlayerShape.sync((class_3222) player); // safe cast - context is server world
            }
        }
    }

    @Inject(method = "makeStuckInBlock", at = @At("HEAD"), cancellable = true)
    private void onStuckInBlock(class_2680 state, class_243 motionMultiplier, CallbackInfo ci) {
        if (PlayerShape.getCurrentShape((class_1657) (Object) this) instanceof class_1628 && state.method_27852(class_2246.field_10343)) {
            ci.cancel();
        }
    }

    @Inject(method = "touch", at = @At("HEAD"))
    private void onTouch(class_1297 entity, CallbackInfo ci) {
        class_1657 ownPlayer = (class_1657) (Object) this;
        if (ownPlayer.method_5805() && PlayerShape.getCurrentShape(ownPlayer) instanceof class_1621 slimeShape && (entity instanceof class_1657 targetPlayer && !(PlayerShape.getCurrentShape(targetPlayer) instanceof class_1621))) {
            int i = slimeShape.method_7152();
            if (this.method_5858(targetPlayer) < 0.6 * (double) i * 0.6 * (double) i
                    && ownPlayer.method_6057(targetPlayer)
                    && targetPlayer.method_5643(ownPlayer.method_48923().method_48812(ownPlayer), (float) ownPlayer.method_26825(class_5134.field_23721))) {
                this.method_5783(class_3417.field_14863, 1.0F, (this.field_5974.method_43057() - this.field_5974.method_43057()) * 0.2F + 1.0F);
                this.method_5723(ownPlayer, targetPlayer);
            }
        }
    }
}
