package tocraft.walkers.mixin;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.api.PlayerShape;

@SuppressWarnings("ConstantConditions")
@Mixin(class_1657.class)
public class PlayerByteStatusMixin {

    // When a player receives a handleStatus byte, pass it on to their shape.
    @Inject(method = "handleEntityEvent", at = @At("RETURN"))
    private void shape$passByteStatus(byte status, CallbackInfo ci) {
        @Nullable class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);
        if (shape != null) {
            shape.method_5711(status);
        }
    }
}
