package tocraft.walkers.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1420;
import net.minecraft.class_1433;
import net.minecraft.class_1453;
import net.minecraft.class_1472;
import net.minecraft.class_1628;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_3486;
import net.minecraft.class_3610;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.world.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.impl.NearbySongAccessor;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.registry.WalkersEntityTags;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 implements NearbySongAccessor {

    @Shadow
    protected abstract int increaseAirSupply(int air);

    @Shadow
    public abstract boolean hasEffect(class_1291 effect);

    protected LivingEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }
	
	@Redirect(method = "baseTick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;setAirSupply(I)V", ordinal = 2))
	private void cancelAirIncrement(class_1309 livingEntity, int air) {
		// Aquatic creatures should not regenerate breath on land
		if ((Object) this instanceof class_1657 player) {
			class_1309 shape = PlayerShape.getCurrentShape(player);

			if (shape != null) {
				if (Walkers.isAquatic(shape)) {
					return;
				}
			}
		}

		this.method_5855(this.increaseAirSupply(this.method_5669()));
	}

    @Redirect(method = "travel", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal = 0))
    private boolean slowFall(class_1309 livingEntity, class_1291 effect) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                if (!this.method_5715() && shape.method_5864().method_20210(WalkersEntityTags.SLOW_FALLING)) {
                    return true;
                }
            }
        }

        return this.hasEffect(class_1294.field_5906);
    }

    @ModifyVariable(method = "travel", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;hasEffect(Lnet/minecraft/world/effect/MobEffect;)Z", ordinal = 1), ordinal = 0)
    public float applyWaterCreatureSwimSpeedBoost(float j) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            // Apply 'Dolphin's Grace' status effect benefits if the player's shape is a
            // water creature
            if (Walkers.isAquatic(shape)) {
                return .96f;
            }
        }

        return j;
    }

    @Inject(method = "causeFallDamage", at = @At(value = "HEAD"), cancellable = true)
    private void causeFallDamage(float fallDistance, float damageMultiplier, class_1282 damageSource,
                                 CallbackInfoReturnable<Boolean> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                boolean takesFallDamage = shape.method_5747(fallDistance, damageMultiplier, damageSource);
                int damageAmount = ((LivingEntityAccessor) shape).callCalculateFallDamage(fallDistance,
                        damageMultiplier);

                if (takesFallDamage && damageAmount > 0) {
                    class_1309.class_6823 fallSounds = shape.method_39760();
                    this.method_5783(damageAmount > 4 ? fallSounds.comp_302() : fallSounds.comp_301(), 1.0F, 1.0F);
                    ((LivingEntityAccessor) shape).callPlayBlockFallSound();
                    this.method_5643(method_48923().method_48827(), (float) damageAmount);
                    cir.setReturnValue(true);
                } else {
                    cir.setReturnValue(false);
                }
            }
        }
    }

    @Inject(method = "hasEffect", at = @At("HEAD"), cancellable = true)
    private void returnHasNightVision(class_1291 effect, CallbackInfoReturnable<Boolean> cir) {
        if ((Object) this instanceof class_1657 player) {
            if (effect.equals(class_1294.field_5925)) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                // Apply 'Night Vision' status effect to player if they are a Bat
                if (shape instanceof class_1420) {
                    cir.setReturnValue(true);
                }
            }
        }
    }

    @Inject(method = "getEffect", at = @At("HEAD"), cancellable = true)
    private void returnNightVisionInstance(class_1291 effect, CallbackInfoReturnable<class_1293> cir) {
        if ((Object) this instanceof class_1657 player) {
            if (effect.equals(class_1294.field_5925)) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                // Apply 'Night Vision' status effect to player if they are a Bat
                if (shape instanceof class_1420) {
                    cir.setReturnValue(new class_1293(class_1294.field_5925, 100000, 0, false, false));
                }
            }
        }
    }

    @Inject(at = @At("HEAD"), method = "getEyeHeight", cancellable = true)
    public void getEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {

            // this is cursed
            try {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                if (shape != null) {
                    cir.setReturnValue(shape.method_18381(pose));
                }
            } catch (Exception ignored) {
            }
        }
    }

    @Inject(method = "isSensitiveToWater", at = @At("HEAD"), cancellable = true)
    protected void shape_isSensitiveToWater(CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 entity = PlayerShape.getCurrentShape(player);

            if (entity != null) {
                cir.setReturnValue(entity.method_29503());
            }
        }
    }

    @Inject(method = "canBreatheUnderwater", at = @At("HEAD"), cancellable = true)
    protected void shape_canBreatheUnderwater(CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 entity = PlayerShape.getCurrentShape(player);

            if (entity != null) {
                cir.setReturnValue(entity.method_6094() || entity instanceof class_1433
                        || entity.method_5864().method_20210(WalkersEntityTags.UNDROWNABLE));
            }
        }
    }

    @Unique
    private boolean walkers$nearbySongPlaying = false;

    @Environment(EnvType.CLIENT)
    @Inject(method = "setRecordPlayingNearby", at = @At("RETURN"))
    protected void shape_setRecordPlayingNearby(class_2338 songPosition, boolean playing, CallbackInfo ci) {
        if ((class_1309) (Object) this instanceof class_1657) {
            walkers$nearbySongPlaying = playing;
        }
    }

    @Override
    public boolean shape_isNearbySongPlaying() {
        return walkers$nearbySongPlaying;
    }

    @Inject(method = "isInvertedHealAndHarm", at = @At("HEAD"), cancellable = true)
    protected void shape_isInvertedHealAndHarm(CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                cir.setReturnValue(shape.method_5999());
            }
        }
    }

    @Inject(method = "canStandOnFluid", at = @At("HEAD"), cancellable = true)
    protected void shape_canStandOnFluid(class_3610 state, CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null && shape.method_5864().method_20210(WalkersEntityTags.LAVA_WALKING) && state.method_15767(class_3486.field_15518)) {
                cir.setReturnValue(true);
            }
        }
    }

    @Inject(method = "onClimbable", at = @At("HEAD"), cancellable = true)
    protected void shape_allowSpiderClimbing(CallbackInfoReturnable<Boolean> cir) {
        if ((class_1309) (Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape instanceof class_1628) {
                cir.setReturnValue(this.field_5976 || this.field_6002.method_8320(this.method_24515()).method_27852(class_2246.field_10343));
            }
        }
    }


    @Inject(method = "eat", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/LivingEntity;addEatEffect(Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/LivingEntity;)V"))
    private void regenerateWoolFromFood(class_1937 level, class_1799 food, CallbackInfoReturnable<class_1799> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape instanceof class_1472 sheepShape) {
                if (sheepShape.method_6629())
                    sheepShape.method_6635(false);
            }
        }
    }

    @Inject(method = "eat", at = @At(value = "RETURN"))
    private void dieFromCookies(class_1937 level, class_1799 food, CallbackInfoReturnable<class_1799> cir) {
        if ((Object) this instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape instanceof class_1453) {
                player.method_6092(new class_1293(class_1294.field_5899, 900));
                if (player.method_7337() || !this.method_5655()) {
                    this.method_5643(this.method_48923().method_48802(player), Float.MAX_VALUE);
                }
            }
        }
    }
}
