package tocraft.walkers.mixin;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_329;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_6862;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.registry.WalkersEntityTags;

@Environment(EnvType.CLIENT)
@Mixin(class_329.class)
public abstract class InGameHudMixin {

    @Shadow
    protected abstract class_1657 getCameraPlayer();

    @ModifyArg(method = "renderPlayerHealth", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/player/Player;isEyeInFluid(Lnet/minecraft/tags/TagKey;)Z"))
    private class_6862<class_3611> shouldRenderBreath(class_6862<class_3611> tag) {
        class_1657 player = this.getCameraPlayer();
        class_1309 shape = PlayerShape.getCurrentShape(player);

        if (shape != null) {
            if (Walkers.isAquatic(shape)
                    || shape.method_5864().method_20210(WalkersEntityTags.UNDROWNABLE) && player.method_5777(class_3486.field_15517)) {
                return class_3486.field_15518; // will cause isEyeInFluid to return false, preventing air render
            }
        }

        return tag;
    }
}
