package tocraft.walkers.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.registry.WalkersEntityTags;

import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1400;
import net.minecraft.class_1422;
import net.minecraft.class_1429;
import net.minecraft.class_1481;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_4019;

@Mixin(class_4019.class)
public abstract class FoxEntityMixin extends class_1429 {

    @Shadow
    @Final
    @Mutable
    private static Predicate<class_1297> AVOID_PLAYERS;

    private FoxEntityMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    // Change the default "flee from player," predicate to ignore players disguised
    // as Foxes.
    // Hopefully nobody else needs to modify fox fleeing behavior.
    static {
        AVOID_PLAYERS = entity -> {
            boolean isShapedPlayer = false;

            if (entity instanceof class_1657 player) {
                class_1309 shape = PlayerShape.getCurrentShape(player);
                if (shape instanceof class_4019) {
                    isShapedPlayer = true;
                }
            }

            return !entity.method_21751() && class_1301.field_6156.test(entity) && !isShapedPlayer;
        };
    }

    @Inject(method = "registerGoals", at = @At("RETURN"))
    private void addPlayerTarget(CallbackInfo ci) {
        this.field_6185.method_6277(7,
                new class_1400<>(this, class_1657.class, 10, false, false, player -> {
                    // ensure foxes can attack players with a shape similar to their normal prey
                    if (!Walkers.CONFIG.foxesAttack2ndShapedPrey) {
                        return false;
                    }

                    // foxes can target players if their shape is in the fox_prey tag, or if they
                    // are an entity that extends FishEntity
                    class_1309 shape = PlayerShape.getCurrentShape((class_1657) player);
                    return shape != null && shape.method_5864().method_20210(WalkersEntityTags.FOX_PREY)
                            || shape instanceof class_1422 || (shape instanceof class_1481 && shape.method_6109());
                }));
    }
}
