package tocraft.walkers.mixin;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1338;
import net.minecraft.class_1451;
import net.minecraft.class_1548;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3701;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.api.PlayerShape;

@Mixin(class_1548.class)
public abstract class CreeperEntityMixin extends class_1588 {

    private CreeperEntityMixin(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Inject(
            method = "registerGoals",
            at = @At("RETURN")
    )
    private void addCustomGoals(CallbackInfo ci) {
        this.field_6201.method_6277(3, new class_1338<>(
                this,
                class_1657.class,
                entity -> {
                    if (entity instanceof class_1657 player) {
                        class_1309 shape = PlayerShape.getCurrentShape(player);
                        return shape instanceof class_3701 || shape instanceof class_1451;
                    }

                    return true;
                },
                6.0F,
                1.0D,
                1.2D,
                player -> true
        ));
    }
}
