package tocraft.walkers.mixin;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1400;
import net.minecraft.class_1451;
import net.minecraft.class_1456;
import net.minecraft.class_1528;
import net.minecraft.class_1548;
import net.minecraft.class_1560;
import net.minecraft.class_1569;
import net.minecraft.class_1613;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_3701;
import net.minecraft.class_5418;
import net.minecraft.world.entity.monster.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.integrations.Integrations;
import tocraft.walkers.integrations.impl.MobBattleModIntegration;

@Mixin(class_1400.class)
public abstract class ActiveTargetGoalMixin extends TrackTargetGoalMixin {

    @Shadow
    protected class_1309 target;

    @Inject(method = "start", at = @At("HEAD"), cancellable = true)
    private void ignoreShapedPlayers(CallbackInfo ci) {
        if (Walkers.CONFIG.hostilesIgnoreHostileShapedPlayer && this.mob instanceof class_1569
                && this.target instanceof class_1657 player && Integrations.mightAttackInnocent(this.mob, player)) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                boolean hasHostility = PlayerHostility.hasHostility(player);

                // only cancel if the player does not have hostility
                if (!hasHostility) {
                    // creepers should ignore cats
                    if (this.mob instanceof class_1548 && (shape instanceof class_3701 || shape instanceof class_1451)) {
                        this.stop();
                        ci.cancel();
                    }

                    // skeletons should ignore wolfs
                    else if (this.mob instanceof class_1613 && shape.method_5864().equals(class_1299.field_6055)) {
                        this.stop();
                        ci.cancel();
                    }

                    // polar bears should ignore polar bears
                    else if (this.mob instanceof class_1456 && shape.method_5864().equals(class_1299.field_6042)) {
                        this.stop();
                        ci.cancel();
                    }

                    // withers should ignore undead
                    else if (this.mob instanceof class_1528 && shape.method_6046().equals(class_1310.field_6289)) {
                        this.stop();
                        ci.cancel();
                    }

                    // hostile mobs (besides wither) should not target players morphed as hostile
                    // mobs
                    else if (!(this.mob instanceof class_1528) && shape instanceof class_1569) {
                        // endermen should attack endermites
                        if (this.mob instanceof class_1560 && shape.method_5864().equals(class_1299.field_6128)) {
                            return;
                        }

                        // Wither Skeletons should attack Piglins
                        else if (this.mob instanceof class_1639 && shape instanceof class_5418) {
                            return;
                        }

                        this.stop();
                        ci.cancel();
                    }
                }
            }
        }
    }

    @Override
    protected void shape_shouldContinue(CallbackInfoReturnable<Boolean> cir) {
        // check cancelling for hostiles
        if (Walkers.CONFIG.hostilesIgnoreHostileShapedPlayer && Walkers.CONFIG.hostilesForgetNewHostileShapedPlayer
                && this.mob instanceof class_1569 && this.target instanceof class_1657 player && Integrations.mightAttackInnocent(this.mob, player)) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            if (shape != null) {
                boolean hasHostility = PlayerHostility.hasHostility(player);

                // only cancel if the player does not have hostility
                if (!hasHostility) {
                    // creepers should ignore cats
                    if (this.mob instanceof class_1548 && shape.method_5864().equals(class_1299.field_6081)) {
                        cir.setReturnValue(false);
                    }

                    // skeletons should ignore wolfs
                    if (this.mob instanceof class_1613 && shape.method_5864().equals(class_1299.field_6055)) {
                        cir.setReturnValue(false);
                    }

                    // withers should ignore undead
                    else if (this.mob instanceof class_1528 && shape.method_6046().equals(class_1310.field_6289)) {
                        cir.setReturnValue(false);
                    }

                    // hostile mobs (besides wither) should not target players morphed as hostile
                    // mobs
                    else if (!(this.mob instanceof class_1528) && shape instanceof class_1569) {
                        cir.setReturnValue(false);
                    }
                }
            }
        }
    }
}
