package tocraft.walkers.integrations;

import dev.architectury.platform.Platform;
import tocraft.walkers.integrations.impl.MobBattleModIntegration;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;

public class Integrations {
    private static final Map<String, AbstractIntegration> INTEGRATIONS = new HashMap<>();

    static {
        register("mobbattle", new MobBattleModIntegration());
    }
    
    public static void initialize() {
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            loadedIntegration.initialize();
        }
    }

    public static boolean mightAttackInnocent(class_1297 entity1, class_1297 entity2) {
        boolean bool = true;
        for (AbstractIntegration loadedIntegration : INTEGRATIONS.values()) {
            bool = bool && loadedIntegration.mightAttackInnocent(entity1, entity2);
        }

        return bool;
    }

    public static void register(String modid, AbstractIntegration integration) {
        if (Platform.isModLoaded(modid))
            INTEGRATIONS.put(modid, integration);
    }
}
