package tocraft.walkers.impl.tick;

import dev.architectury.event.events.client.ClientTickEvent;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3966;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.ClientNetworking;
import tocraft.walkers.network.impl.SpecialSwapPackets;
import tocraft.walkers.network.impl.SwapPackets;
import tocraft.walkers.network.impl.UnlockPackets;
import tocraft.walkers.registry.WalkersEntityTags;

public class KeyPressHandler implements ClientTickEvent.Client {
    private float currentTimer = 0f;

    @Override
    public void tick(class_310 client) {
        assert client.field_1724 != null;

        if (WalkersClient.ABILITY_KEY.method_1436()) handleAbilityKey(client);

        if (WalkersClient.TRANSFORM_KEY.method_1436()) {
            SwapPackets.sendSwapRequest();
        }

        if (WalkersClient.SPECIAL_TRANSFORM_KEY.method_1436()) {
            if (Walkers.hasSpecialShape(client.field_1724.method_5667())) SpecialSwapPackets.sendSpecialSwapRequest();
            else client.field_1724.method_7353(class_2561.method_43471("walkers.not_special"), true);
        }

        if (WalkersClient.UNLOCK_KEY.method_1434()) handleUnlockKey(client);

        else if (currentTimer != Walkers.CONFIG.unlockTimer) currentTimer = Walkers.CONFIG.unlockTimer;
    }

    private void handleAbilityKey(class_310 client) {
        // TODO: maybe the check should be on the server to allow for ability extension
        // mods?
        // Only send the ability packet if the shape equipped by the player has one
        class_1309 shape = PlayerShape.getCurrentShape(client.field_1724);

        if (shape != null) {
            if (AbilityRegistry.has(shape)) {
                ClientNetworking.sendAbilityRequest();
            }
        }
    }

    @SuppressWarnings("ConstantConditions")
    private void handleUnlockKey(class_310 client) {
        // check if player is blacklisted
        if (client.field_1724 != null && Walkers.isPlayerBlacklisted(client.field_1724.method_5667())) {
            client.field_1724.method_7353(class_2561.method_43471("walkers.player_blacklisted"), true);
            return;
        }

        class_239 hit = client.field_1765;
        if (client.field_1724 != null && (((PlayerDataProvider) client.field_1724).walkers$get2ndShape() == null || Walkers.CONFIG.unlockOverridesCurrentShape) && hit instanceof class_3966) {
            class_1297 entityHit = ((class_3966) hit).method_17782();
            if (entityHit instanceof class_1309 living) {
                @Nullable ShapeType<?> type = ShapeType.from(living);

                if (type != null) {
                    // Ensures, the mob isn't on the blacklist
                    if (type.getEntityType().method_20210(WalkersEntityTags.BLACKLISTED))
                        client.field_1724.method_7353(class_2561.method_43471("walkers.unlock_entity_blacklisted"), true);
                    else {
                        if (currentTimer <= 0) {
                            // unlock shape
                            UnlockPackets.sendUnlockRequest(type);
                            // send unlock message
                            class_2561 name = class_2561.method_43471(type.getEntityType().method_5882());
                            client.field_1724.method_7353(class_2561.method_43469("walkers.unlock_entity", name), true);
                            currentTimer = Walkers.CONFIG.unlockTimer;
                        } else {
                            client.field_1724.method_7353(class_2561.method_43471("walkers.unlock_progress"), true);
                            currentTimer -= 1;
                        }
                    }
                }
            }
        } else currentTimer = Walkers.CONFIG.unlockTimer;
    }
}
