package tocraft.walkers.command;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import tocraft.walkers.Walkers;

import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_5242;

public class BlacklistCommands {
    public static LiteralCommandNode<class_2168> getRootNode() {
        LiteralCommandNode<class_2168> rootNode = class_2170.method_9247("playerBlacklist").build();

        LiteralCommandNode<class_2168> isWhitelist = class_2170.method_9247("isWhitelist")
                .executes(context -> isWhitelist(context.getSource()))
                .then(class_2170.method_9244("value", BoolArgumentType.bool())
                        .executes(context -> setIsWhitelist(context.getSource(), BoolArgumentType.getBool(context, "value"))))
                .build();

        LiteralCommandNode<class_2168> addToList = class_2170.method_9247("add")
                .then(class_2170.method_9244("players", class_2186.method_9308())
                        .executes(context -> {
                            for (class_3222 player : class_2186.method_9312(context, "players")) {
                                addToList(context.getSource(), player.method_5667());
                            }
                            return 1;
                        }))
                .then(class_2170.method_9244("playerUUID", class_5242.method_27643())
                        .executes(context -> {
                            addToList(context.getSource(), class_5242.method_27645(context, "playerUUID"));
                            return 1;
                        }))
                .build();
        LiteralCommandNode<class_2168> removeFromList = class_2170.method_9247("remove")
                .then(class_2170.method_9244("players", class_2186.method_9308())
                        .executes(context -> {
                            for (class_3222 player : class_2186.method_9312(context, "players")) {
                                removeFromList(context.getSource(), player.method_5667());
                            }
                            return 1;
                        })
                        .then(class_2170.method_9244("playerUUID", class_5242.method_27643())
                                .executes(context -> {
                                    removeFromList(context.getSource(), class_5242.method_27645(context, "playerUUID"));
                                    return 1;
                                })))
                .build();

        LiteralCommandNode<class_2168> listList = class_2170.method_9247("list")
                .executes(context -> listPlayers(context.getSource()))
                .build();


        rootNode.addChild(isWhitelist);
        rootNode.addChild(listList);
        rootNode.addChild(addToList);
        rootNode.addChild(removeFromList);
        return rootNode;
    }

    private static int isWhitelist(class_2168 source) {
        source.method_45068(class_2561.method_43469("walkers.isWhitelist", Walkers.CONFIG.playerBlacklistIsWhitelist));
        return 1;
    }

    private static int setIsWhitelist(class_2168 source, boolean value) {
        Walkers.CONFIG.playerBlacklistIsWhitelist = value;
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        source.method_45068(class_2561.method_43469("walkers.setIsWhitelist", String.valueOf(value)));
        return 1;
    }

    private static int listPlayers(class_2168 source) {
        for (UUID uuid : Walkers.CONFIG.playerUUIDBlacklist) {
            class_3222 player = source.method_9211().method_3760().method_14602(uuid);
            class_2561 name = player != null ? player.method_5476() : class_2561.method_43470(uuid.toString());
            source.method_45068(class_2561.method_43469("walkers.blacklistListPlayer", name));
        }

        if (Walkers.CONFIG.playerUUIDBlacklist.isEmpty())
            source.method_45068(class_2561.method_43471("walkers.blacklistIsEmpty"));

        return 1;
    }

    private static void addToList(class_2168 source, UUID uuid) {
        Walkers.CONFIG.playerUUIDBlacklist.add(uuid);
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        class_3222 player = source.method_9211().method_3760().method_14602(uuid);
        class_2561 name = player != null ? player.method_5476() : class_2561.method_43470(uuid.toString());
        source.method_45068(class_2561.method_43469("walkers.addToList", name));
    }

    private static void removeFromList(class_2168 source, UUID uuid) {
        Walkers.CONFIG.playerUUIDBlacklist.remove(uuid);
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        class_3222 player = source.method_9211().method_3760().method_14602(uuid);
        class_2561 name = player != null ? player.method_5476() : class_2561.method_43470(uuid.toString());
        source.method_45068(class_2561.method_43469("walkers.removeFromList", name));
    }
}
