package tocraft.walkers.api.variant;

import java.util.Locale;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_5250;

public abstract class TypeProvider<T extends class_1309> {
    @SuppressWarnings("unchecked")
    public ShapeType<T> create(T entity) {
        return ShapeType.from((class_1299<T>) entity.method_5864(), getVariantData(entity));
    }

    public abstract int getVariantData(T entity);

    public abstract T create(class_1299<T> type, class_1937 world, int data);

    public abstract int getFallbackData();

    public abstract int getRange();

    public abstract class_2561 modifyText(T entity, class_5250 text);

    public final String formatTypePrefix(String prefix) {
        return String.valueOf(prefix.charAt(0)).toUpperCase(Locale.ROOT) + prefix.substring(1);
    }
}
