package tocraft.walkers.api.data.variants;

import com.google.gson.*;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.architectury.platform.Platform;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

import java.lang.reflect.InvocationTargetException;
import java.util.AbstractMap.SimpleEntry;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_156;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class TypeProviderDataManager extends class_4309 {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, new class_2960.class_2961()).create();

    public TypeProviderDataManager() {
        super(GSON, Walkers.MODID + "/variants");
    }

    @SuppressWarnings("unchecked")
    @Override
    protected void apply(Map<class_2960, JsonElement> map, class_3300 resourceManager, class_3695 profiler) {
        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            Map.Entry<class_1299<?>, TypeProvider<?>> convertedEntry = typeProviderFromJson(mapEntry.getKey(), mapEntry.getValue().getAsJsonObject());

            if (convertedEntry.getKey() != null && convertedEntry.getValue() != null) {
                TypeProviderRegistry.register((class_1299<class_1309>) convertedEntry.getKey(), (TypeProvider<class_1309>) convertedEntry.getValue());

                Walkers.LOGGER.info("{}: {} registered for {}", getClass().getSimpleName(), convertedEntry.getKey(), convertedEntry.getValue());
            }
        }
    }

    @SuppressWarnings("unchecked")
    protected static Map.Entry<class_1299<?>, TypeProvider<?>> typeProviderFromJson(class_2960 id, JsonObject json) {
        Codec<Map.Entry<class_1299<?>, TypeProvider<?>>> codec = RecordCodecBuilder.create((instance) -> instance.group(
                class_2960.field_25139.fieldOf("entity_type").forGetter(o -> class_7923.field_41177.method_10221(o.getKey())),
                Codec.STRING.optionalFieldOf("required_mod", "").forGetter(o -> ""),
                class_2960.field_25139.optionalFieldOf("parent").forGetter(o -> Optional.of(class_7923.field_41177.method_10221(o.getKey()))),
                Codec.STRING.optionalFieldOf("type_provider_class").forGetter(o -> Optional.of(o.getValue().getClass().getName())),
                NBTTypeProvider.CODEC.optionalFieldOf("type_provider").forGetter(o -> {
                    if (o.getValue() instanceof NBTTypeProvider<?> nbtTypeProvider)
                        return Optional.of(nbtTypeProvider);
                    else
                        return Optional.empty();
                })
        ).apply(instance, instance.stable((entityType, requiredMod, parent, typeProviderClassOptional, typeProviderOptional) -> {
            if ((requiredMod.isBlank() || Platform.isModLoaded(requiredMod)) && class_7923.field_41177.method_10250(entityType)) {
                TypeProvider<?> typeProvider;
                if (parent.isPresent()) {
                    typeProvider = TypeProviderRegistry.getProvider((class_1299<? extends class_1309>) class_7923.field_41177.method_10223(parent.get()));
                }
                else if (typeProviderClassOptional.isPresent()) {
                    try {
                        typeProvider = Class.forName(typeProviderClassOptional.get()).asSubclass(TypeProvider.class).getDeclaredConstructor().newInstance();
                    } catch (InstantiationException | IllegalAccessException | InvocationTargetException |
                             NoSuchMethodException | ClassNotFoundException e) {
                        Walkers.LOGGER.error("{}: No valid type provider class registered for {}", TypeProviderDataManager.class.getSimpleName(), id);
                        return new SimpleEntry<>(class_7923.field_41177.method_10223(entityType), null);
                    }
                } else if (typeProviderOptional.isPresent()) {
                    typeProvider = typeProviderOptional.get();
                } else {
                    Walkers.LOGGER.error("{}: No valid type provider registered for {}", TypeProviderDataManager.class.getSimpleName(), id);
                    return new SimpleEntry<>(class_7923.field_41177.method_10223(entityType), null);
                }
                return new SimpleEntry<>(class_7923.field_41177.method_10223(entityType), typeProvider);
            } else if (requiredMod.isBlank() || Platform.isModLoaded(requiredMod)) {
                Walkers.LOGGER.info("{}: EntityType not found for {}", TypeProviderDataManager.class.getSimpleName(), id);
            }
            return new SimpleEntry<>(null, null);
        })));
        return class_156.method_47526(codec.parse(JsonOps.INSTANCE, json), JsonParseException::new);
    }
}
