package tocraft.walkers.ability;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_7923;
import tocraft.walkers.Walkers;

public abstract class ShapeAbility<E extends class_1309> {
    /**
     * Defines the use action of this ability. Implementers can assume the ability checks, such as cool-downs, have successfully passed.
     *
     * @param player player using the ability
     * @param shape  current shape of the player
     * @param world  world the player is residing in
     */
    abstract public void onUse(class_1657 player, E shape, class_1937 world);

    /**
     * @return cooldown of this ability, in ticks, after it is used.
     */
    public int getCooldown(E entity) {
        String id = class_7923.field_41177.method_10221(entity.method_5864()).toString();
        return Walkers.CONFIG.abilityCooldownMap.getOrDefault(id, getDefaultCooldown());
    }

    public int getDefaultCooldown() {
        return 20;
    }

    abstract public class_1792 getIcon();
}
