package tocraft.walkers.ability;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_1454;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1606;
import net.minecraft.class_1640;
import net.minecraft.class_3417;
import net.minecraft.class_4466;
import net.minecraft.class_5354;
import net.minecraft.class_6053;
import net.minecraft.class_7260;
import net.minecraft.class_7923;
import net.minecraft.world.entity.animal.*;
import net.minecraft.world.entity.monster.*;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.impl.*;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public class AbilityRegistry {

    private static final Map<Predicate<class_1309>, ShapeAbility<?>> abilities = new LinkedHashMap<>();

    private AbilityRegistry() {

    }

    public static void init() {
        // Register generic Abilities first (since the last registered ability will be the used one
        register((Predicate<class_1309>) livingEntity -> livingEntity instanceof class_5354, new AngerAbility<>());

        // Register 'normal' Abilities
        register(class_1545.class, new BlazeAbility<>());
        register(class_1548.class, new CreeperAbility<>());
        register(class_1510.class, new EnderDragonAbility<>());
        register(class_1560.class, new EndermanAbility<>());
        register(class_1571.class, new GhastAbility<>());
        register(class_1473.class, new SnowGolemAbility<>());
        register(class_1528.class, new WitherAbility<>());
        register(class_1430.class, new CowAbility<>());
        register(class_6053.class, new CowAbility<>());
        register(class_1559.class, new EndermiteAbility<>());
        register(class_1501.class, new LlamaAbility<>());
        register(class_1640.class, new WitchAbility<>());
        register(class_1564.class, new EvokerAbility<>());
        register(class_7260.class, new WardenAbility<>());
        register(class_1493.class, new AngerAbility<>(class_3417.field_14922, class_3417.field_14575));
        register(class_1472.class, new SheepAbility<>());
        register(class_1428.class, new ChickenAbility<>());
        register(class_1438.class, new MushroomCowAbility<>());
        register(class_1496.class, new HorseAbility<>());
        register(class_4466.class, new AngerAbility<>(class_3417.field_20605, class_3417.field_20604));
        register(class_1606.class, new ShulkerAbility<>());
        register(class_1454.class, new PufferfishAbility<>());
    }

    /**
     * @return the last registered {@link ShapeAbility} for the specified shape
     */
    @SuppressWarnings("unchecked")
    public static <L extends class_1309> ShapeAbility<L> get(L shape) {
        // check ability blacklist
        if (Walkers.CONFIG.abilityBlacklist.contains(class_7923.field_41177.method_10221(shape.method_5864()).toString()))
            return null;

        List<ShapeAbility<?>> shapeAbilities = new ArrayList<>(abilities.entrySet().stream().filter(entry -> entry.getKey().test(shape)).map(Map.Entry::getValue).toList());
        return !shapeAbilities.isEmpty() ? (ShapeAbility<L>) shapeAbilities.get(shapeAbilities.size() - 1) : null;
    }

    public static <A extends class_1309, T extends class_1299<A>> void register(T type, ShapeAbility<A> ability) {
        register((Predicate<class_1309>) livingEntity -> type.equals(livingEntity.method_5864()), ability);
    }

    public static <A extends class_1309> void register(Class<A> entityClass, ShapeAbility<A> ability) {
        register((Predicate<class_1309>) entityClass::isInstance, ability);
    }

    /**
     * Register an ability for a predicate
     *
     * @param entityPredicate this should only be true, if the entity is the correct class for the ability!
     * @param ability         your {@link ShapeAbility}
     */
    public static void register(Predicate<class_1309> entityPredicate, ShapeAbility<?> ability) {
        abilities.put(entityPredicate, ability);
    }

    public static <L extends class_1309> boolean has(L shape) {
        // check ability blacklist

        if (Walkers.CONFIG.abilityBlacklist.contains(class_7923.field_41177.method_10221(shape.method_5864()).toString()))
            return false;
        return abilities.keySet().stream().anyMatch(predicate -> predicate.test(shape));
    }
}
