package tocraft.walkers;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import net.minecraft.class_304;
import net.minecraft.class_3675;
import org.lwjgl.glfw.GLFW;
import tocraft.walkers.ability.AbilityOverlayRenderer;
import tocraft.walkers.api.model.EntityArms;
import tocraft.walkers.api.model.EntityUpdaters;
import tocraft.walkers.impl.tick.KeyPressHandler;
import tocraft.walkers.network.ClientNetworking;

public class WalkersClient {
    public static final class_304 UNLOCK_KEY = new class_304("key.walkers_unlock", class_3675.class_307.field_1668, GLFW.GLFW_KEY_U, "key.categories.walkers");
    public static final class_304 TRANSFORM_KEY = new class_304("key.walkers", class_3675.class_307.field_1668, GLFW.GLFW_KEY_G, "key.categories.walkers");
    public static final class_304 ABILITY_KEY = new class_304("key.walkers_ability", class_3675.class_307.field_1668, GLFW.GLFW_KEY_R, "key.categories.walkers");
    public static final class_304 SPECIAL_TRANSFORM_KEY = new class_304("key.walkers_special", class_3675.field_16237.method_1444(), "key.categories.walkers");

    public void initialize() {
        KeyMappingRegistry.register(ABILITY_KEY);
        KeyMappingRegistry.register(TRANSFORM_KEY);
        KeyMappingRegistry.register(UNLOCK_KEY);
        KeyMappingRegistry.register(SPECIAL_TRANSFORM_KEY);

        // Register client-side event handlers
        EntityUpdaters.init();
        AbilityOverlayRenderer.register();
        EntityArms.init();

        // Register event handlers
        ClientTickEvent.CLIENT_PRE.register(new KeyPressHandler());
        ClientNetworking.registerPacketHandlers();
    }
}
