/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.mixin.player;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1433;
import net.minecraft.class_1454;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2715;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_4051;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.ability.impl.specific.GrassEaterAbility;
import tocraft.walkers.api.PlayerAbilities;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.WalkersTickHandler;
import tocraft.walkers.api.WalkersTickHandlers;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.impl.ShapeDataProvider;
import tocraft.walkers.mixin.accessor.DolphinAccessor;
import tocraft.walkers.mixin.accessor.PufferfishAccessor;
import tocraft.walkers.mixin.accessor.SheepAccessor;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.MobEffectTrait;

@Mixin(value={class_1657.class})
public abstract class PlayerEntityTickMixin
extends class_1309 {
    @Unique
    private static Predicate<class_2680> walkers$IS_TALL_GRASS = null;

    private PlayerEntityTickMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void serverTick(CallbackInfo info) {
        WalkersTickHandler<?> handler;
        @Nullable class_1309 shape = PlayerShape.getCurrentShape((class_1657)this);
        if (shape != null && (handler = WalkersTickHandlers.getHandlers().get(shape.method_5864())) != null) {
            handler.tick((class_1657)this, shape);
        }
        if (!CEntity.level((class_1297)this).field_9236) {
            PlayerDataProvider data = (PlayerDataProvider)((Object)this);
            data.walkers$setRemainingHostilityTime(Math.max(0, data.walkers$getRemainingHostilityTime() - 1));
            class_3222 player = (class_3222)this;
            PlayerAbilities.setCooldown((class_1657)player, Math.max(0, data.walkers$getAbilityCooldown() - 1));
            PlayerAbilities.sync(player);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void setShapeData(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657)this);
        if (shape instanceof ShapeDataProvider) {
            ShapeDataProvider shapeData = (ShapeDataProvider)shape;
            if (!shapeData.walkers$isShape()) {
                shapeData.walkers$setIsShape(true);
            }
            shapeData.walkers$setPlayerDamageSource(class_1282.method_5532((class_1657)((class_1657)this)));
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void pufferfishServerTick(CallbackInfo info) {
        class_1309 shape;
        if (!CEntity.level((class_1297)this).field_9236 && this.method_5805() && (shape = PlayerShape.getCurrentShape((class_1657)this)) instanceof class_1454) {
            class_1454 pufferfishShape = (class_1454)shape;
            if (((PufferfishAccessor)pufferfishShape).getInflateCounter() > 0) {
                if (pufferfishShape.method_6594() == 0) {
                    this.method_5783(class_3417.field_15235, this.method_6107(), this.method_6017());
                    pufferfishShape.method_6596(1);
                } else if (((PufferfishAccessor)pufferfishShape).getInflateCounter() > 40 && pufferfishShape.method_6594() == 1) {
                    this.method_5783(class_3417.field_15235, this.method_6107(), this.method_6017());
                    pufferfishShape.method_6596(2);
                }
                ((PufferfishAccessor)pufferfishShape).setInflateCounter(((PufferfishAccessor)pufferfishShape).getInflateCounter() + 1);
            } else if (pufferfishShape.method_6594() != 0) {
                if (((PufferfishAccessor)pufferfishShape).getDeflateTimer() > 60 && pufferfishShape.method_6594() == 2) {
                    this.method_5783(class_3417.field_15133, this.method_6107(), this.method_6017());
                    pufferfishShape.method_6596(1);
                } else if (((PufferfishAccessor)pufferfishShape).getDeflateTimer() > 100 && pufferfishShape.method_6594() == 1) {
                    this.method_5783(class_3417.field_15133, this.method_6107(), this.method_6017());
                    pufferfishShape.method_6596(0);
                }
                ((PufferfishAccessor)pufferfishShape).setDeflateTimer(((PufferfishAccessor)pufferfishShape).getDeflateTimer() + 1);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void dolphinServerTick(CallbackInfo info) {
        class_1657 nearestPlayer;
        class_1657 player;
        class_1309 shape;
        if (!CEntity.level((class_1297)this).field_9236 && this.method_5805() && (shape = PlayerShape.getCurrentShape(player = (class_1657)this)) instanceof class_1433 && (nearestPlayer = CEntity.level((class_1297)player).method_18462(DolphinAccessor.getSWIM_WITH_PLAYER_TARGETING(), (class_1309)player)) != null && nearestPlayer.method_5681()) {
            nearestPlayer.method_37222(new class_1293(class_1294.field_5900, 100), (class_1297)player);
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void applyMobEffectTrait(CallbackInfo info) {
        class_1657 player;
        class_1309 shape;
        if (!CEntity.level((class_1297)this).field_9236 && this.method_5805() && TraitRegistry.has(shape = PlayerShape.getCurrentShape(player = (class_1657)this), MobEffectTrait.ID)) {
            List<MobEffectTrait> traitList = TraitRegistry.get(shape, MobEffectTrait.ID).stream().map(trait -> (MobEffectTrait)trait).toList();
            block5: for (MobEffectTrait mobEffectTrait : traitList) {
                class_1293 mobEffectInstance = mobEffectTrait.mobEffectInstance;
                if (mobEffectTrait.showInInventory && mobEffectTrait.applyToSelf) {
                    player.method_37222(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), (class_1297)player);
                }
                switch (mobEffectTrait.applyToNearby) {
                    case 0: {
                        List nearbyPlayers = CEntity.level((class_1297)player).method_18464(class_4051.method_36626().method_18418((double)mobEffectTrait.maxDistanceForEntities).method_36627(), (class_1309)player, player.method_5829().method_1009((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        if (nearbyPlayers.isEmpty()) continue block5;
                        for (int i = 0; i < nearbyPlayers.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((class_1657)nearbyPlayers.get(i)).method_37222(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), (class_1297)player);
                        }
                        continue block5;
                    }
                    case 1: {
                        List nearbyMobs = CEntity.level((class_1297)player).method_18466(class_1308.class, class_4051.method_36626().method_18418((double)mobEffectTrait.maxDistanceForEntities).method_36627(), (class_1309)player, player.method_5829().method_1009((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        if (nearbyMobs.isEmpty()) continue block5;
                        for (int i = 0; i < nearbyMobs.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((class_1308)nearbyMobs.get(i)).method_37222(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), (class_1297)player);
                        }
                        continue block5;
                    }
                    case 2: {
                        List nearbyMobs = CEntity.level((class_1297)player).method_18466(class_1308.class, class_4051.method_36626().method_18418((double)mobEffectTrait.maxDistanceForEntities).method_36627(), (class_1309)player, player.method_5829().method_1009((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        List nearbyPlayers = CEntity.level((class_1297)player).method_18464(class_4051.method_36626().method_18418((double)mobEffectTrait.maxDistanceForEntities).method_36627(), (class_1309)player, player.method_5829().method_1009((double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities, (double)mobEffectTrait.maxDistanceForEntities));
                        ArrayList nearbyEntites = new ArrayList();
                        nearbyEntites.addAll(nearbyMobs);
                        nearbyEntites.addAll(nearbyPlayers);
                        nearbyEntites.sort((first, second) -> Float.compare(player.method_5739((class_1297)first), player.method_5739((class_1297)second)));
                        if (nearbyEntites.isEmpty()) break;
                        for (int i = 0; i < nearbyEntites.size() && (mobEffectTrait.amountOfEntitiesToApplyTo < 0 || i < mobEffectTrait.amountOfEntitiesToApplyTo); ++i) {
                            ((class_1308)nearbyMobs.get(i)).method_37222(new class_1293(mobEffectInstance.method_5579(), mobEffectInstance.method_5584(), mobEffectInstance.method_5578(), mobEffectInstance.method_5591(), mobEffectInstance.method_5581(), mobEffectInstance.method_5592()), (class_1297)player);
                        }
                        break;
                    }
                }
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void sheepServerTick(CallbackInfo info) {
        ShapeAbility<class_1309> shapeAbility;
        class_3222 serverPlayer;
        class_1309 shape;
        if (walkers$IS_TALL_GRASS == null) {
            walkers$IS_TALL_GRASS = class_2715.method_11758((class_2248)((class_2248)CEntity.level((class_1297)this).method_30349().method_30530(CRegistries.getRegistry((class_2960)Identifier.parse((String)"block")).method_30517()).method_10223(Identifier.parse((String)"grass"))));
        }
        if (!CEntity.level((class_1297)this).field_9236 && this.method_5805() && (shape = PlayerShape.getCurrentShape((class_1657)(serverPlayer = (class_3222)this))) != null && (shapeAbility = AbilityRegistry.get(shape)) instanceof GrassEaterAbility) {
            GrassEaterAbility grassEaterAbility = (GrassEaterAbility)shapeAbility;
            if (grassEaterAbility.eatTick.get(serverPlayer.method_5667()) != null && grassEaterAbility.eatTick.get(serverPlayer.method_5667()) != 0) {
                grassEaterAbility.eatTick.put(serverPlayer.method_5667(), Math.max(0, grassEaterAbility.eatTick.get(serverPlayer.method_5667()) - 1));
                if (shape instanceof class_1472) {
                    class_1472 sheepShape = (class_1472)shape;
                    ((SheepAccessor)sheepShape).setEatAnimationTick(grassEaterAbility.eatTick.get(serverPlayer.method_5667()));
                }
                if (grassEaterAbility.eatTick.get(serverPlayer.method_5667()) == class_3532.method_38788((int)4, (int)2)) {
                    class_2338 blockPos = serverPlayer.method_24515();
                    if (walkers$IS_TALL_GRASS.test(CEntity.level((class_1297)this).method_8320(blockPos)) && this.walkers$isLookingAtPos(blockPos)) {
                        CEntity.level((class_1297)this).method_22352(blockPos, false);
                        this.method_32876(class_5712.field_28735);
                        serverPlayer.method_7344().method_7585(3, 0.2f);
                        if (shape instanceof class_1472) {
                            class_1472 sheepShape = (class_1472)shape;
                            sheepShape.method_6635(false);
                        }
                    } else {
                        class_2338 blockPos2 = blockPos.method_10074();
                        if (CEntity.level((class_1297)this).method_8320(blockPos2).method_27852(class_2246.field_10219) && this.walkers$isLookingAtPos(blockPos2)) {
                            CEntity.level((class_1297)this).method_20290(2001, blockPos2, class_2248.method_9507((class_2680)class_2246.field_10219.method_9564()));
                            CEntity.level((class_1297)this).method_8652(blockPos2, class_2246.field_10566.method_9564(), 2);
                            this.method_32876(class_5712.field_28735);
                            serverPlayer.method_7344().method_7585(3, 0.1f);
                            if (shape instanceof class_1472) {
                                class_1472 sheepShape = (class_1472)shape;
                                sheepShape.method_6635(false);
                            }
                        }
                    }
                }
            }
        }
    }

    @Unique
    private boolean walkers$isLookingAtPos(class_2338 blockPos) {
        class_3965 blockHitResult;
        class_1657 player = (class_1657)this;
        class_239 class_2392 = player.method_5745(2.0, 0.0f, false);
        return class_2392 instanceof class_3965 && (blockHitResult = (class_3965)class_2392).method_17777().equals((Object)blockPos);
    }
}

