/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.traits;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1299;
import net.minecraft.class_1307;
import net.minecraft.class_1309;
import net.minecraft.class_1311;
import net.minecraft.class_1420;
import net.minecraft.class_1428;
import net.minecraft.class_1433;
import net.minecraft.class_1439;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1547;
import net.minecraft.class_1548;
import net.minecraft.class_1569;
import net.minecraft.class_1584;
import net.minecraft.class_1593;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1628;
import net.minecraft.class_1634;
import net.minecraft.class_1639;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_3483;
import net.minecraft.class_3486;
import net.minecraft.class_3611;
import net.minecraft.class_3701;
import net.minecraft.class_3763;
import net.minecraft.class_4019;
import net.minecraft.class_4466;
import net.minecraft.class_4985;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.integrations.Integrations;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.impl.AquaticTrait;
import tocraft.walkers.traits.impl.AttackForHealthTrait;
import tocraft.walkers.traits.impl.BurnInDaylightTrait;
import tocraft.walkers.traits.impl.CantInteractTrait;
import tocraft.walkers.traits.impl.CantSwimTrait;
import tocraft.walkers.traits.impl.ClimbBlocksTrait;
import tocraft.walkers.traits.impl.FearedTrait;
import tocraft.walkers.traits.impl.FlyingTrait;
import tocraft.walkers.traits.impl.HumanoidTrait;
import tocraft.walkers.traits.impl.ImmunityTrait;
import tocraft.walkers.traits.impl.InstantDieOnDamageMsgTrait;
import tocraft.walkers.traits.impl.MobEffectTrait;
import tocraft.walkers.traits.impl.NoPhysicsTrait;
import tocraft.walkers.traits.impl.NocturnalTrait;
import tocraft.walkers.traits.impl.PreyTrait;
import tocraft.walkers.traits.impl.ReinforcementsTrait;
import tocraft.walkers.traits.impl.RiderTrait;
import tocraft.walkers.traits.impl.SlowFallingTrait;
import tocraft.walkers.traits.impl.StandOnFluidTrait;
import tocraft.walkers.traits.impl.TemperatureTrait;
import tocraft.walkers.traits.impl.UndrownableTrait;
import tocraft.walkers.traits.impl.WalkOnPowderSnow;

public class TraitRegistry {
    private static final Map<Predicate<class_1309>, List<ShapeTrait<?>>> traitsByPredicates = new ConcurrentHashMap();
    private static final Map<class_1299<? extends class_1309>, List<ShapeTrait<?>>> traitsByEntityTypes = new ConcurrentHashMap();
    private static final Map<class_6862<class_1299<?>>, List<ShapeTrait<?>>> traitsByEntityTags = new ConcurrentHashMap();
    private static final Map<Class<? extends class_1309>, List<ShapeTrait<?>>> traitsByEntityClasses = new ConcurrentHashMap();
    private static final Map<class_2960, MapCodec<? extends ShapeTrait<?>>> traitCodecById = new HashMap();
    private static final Map<MapCodec<? extends ShapeTrait<?>>, class_2960> traitIdByCodec = new IdentityHashMap();

    public static void initialize() {
        TraitRegistry.registerCodec(MobEffectTrait.ID, MobEffectTrait.CODEC);
        TraitRegistry.registerCodec(BurnInDaylightTrait.ID, BurnInDaylightTrait.CODEC);
        TraitRegistry.registerCodec(FlyingTrait.ID, FlyingTrait.CODEC);
        TraitRegistry.registerCodec(PreyTrait.ID, PreyTrait.CODEC);
        TraitRegistry.registerCodec(TemperatureTrait.ID, TemperatureTrait.CODEC);
        TraitRegistry.registerCodec(RiderTrait.ID, RiderTrait.CODEC);
        TraitRegistry.registerCodec(StandOnFluidTrait.ID, StandOnFluidTrait.CODEC);
        TraitRegistry.registerCodec(NoPhysicsTrait.ID, NoPhysicsTrait.CODEC);
        TraitRegistry.registerCodec(CantSwimTrait.ID, CantSwimTrait.CODEC);
        TraitRegistry.registerCodec(UndrownableTrait.ID, UndrownableTrait.CODEC);
        TraitRegistry.registerCodec(SlowFallingTrait.ID, SlowFallingTrait.CODEC);
        TraitRegistry.registerCodec(FearedTrait.ID, FearedTrait.CODEC);
        TraitRegistry.registerCodec(ClimbBlocksTrait.ID, ClimbBlocksTrait.CODEC);
        TraitRegistry.registerCodec(ReinforcementsTrait.ID, ReinforcementsTrait.CODEC);
        TraitRegistry.registerCodec(InstantDieOnDamageMsgTrait.ID, InstantDieOnDamageMsgTrait.CODEC);
        TraitRegistry.registerCodec(AquaticTrait.ID, AquaticTrait.CODEC);
        TraitRegistry.registerCodec(WalkOnPowderSnow.ID, WalkOnPowderSnow.CODEC);
        TraitRegistry.registerCodec(HumanoidTrait.ID, HumanoidTrait.CODEC);
        TraitRegistry.registerCodec(AttackForHealthTrait.ID, AttackForHealthTrait.CODEC);
        TraitRegistry.registerCodec(NocturnalTrait.ID, NocturnalTrait.CODEC);
        TraitRegistry.registerCodec(CantInteractTrait.ID, CantInteractTrait.CODEC);
        TraitRegistry.registerCodec(ImmunityTrait.ID, ImmunityTrait.CODEC);
    }

    public static void registerDefault() {
        TraitRegistry.registerByClass(class_1420.class, new MobEffectTrait(new class_1293(class_1294.field_5925, 100000, 0, false, false)));
        TraitRegistry.registerByClass(class_1642.class, new BurnInDaylightTrait());
        TraitRegistry.registerByClass(class_1613.class, new BurnInDaylightTrait());
        TraitRegistry.registerByClass(class_1627.class, new BurnInDaylightTrait());
        TraitRegistry.registerByClass(class_1593.class, new BurnInDaylightTrait());
        TraitRegistry.registerByClass(class_1420.class, new FlyingTrait());
        TraitRegistry.registerByClass(class_4466.class, new FlyingTrait());
        TraitRegistry.registerByClass(class_1545.class, new FlyingTrait());
        TraitRegistry.registerByClass(class_1510.class, new FlyingTrait());
        TraitRegistry.registerByClass(class_1307.class, new FlyingTrait());
        TraitRegistry.registerByClass(class_1453.class, new FlyingTrait());
        TraitRegistry.registerByClass(class_1634.class, new FlyingTrait());
        TraitRegistry.registerByClass(class_1528.class, new FlyingTrait());
        TraitRegistry.registerByClass(class_1420.class, PreyTrait.ofHunterClass(class_1493.class));
        TraitRegistry.registerByClass(class_4019.class, PreyTrait.ofHunterClass(class_1493.class));
        TraitRegistry.registerByClass(class_1472.class, PreyTrait.ofHunterClass(class_1493.class));
        TraitRegistry.registerByClass(class_1613.class, PreyTrait.ofHunterClass(class_1493.class));
        TraitRegistry.registerByClass(class_1453.class, PreyTrait.ofHunterClass(class_1493.class));
        TraitRegistry.registerByClass(class_1463.class, PreyTrait.ofHunterClass(class_1493.class));
        TraitRegistry.registerByClass(class_1428.class, PreyTrait.ofHunterClass(class_4019.class));
        TraitRegistry.registerByClass(class_1463.class, PreyTrait.ofHunterClass(class_4019.class));
        TraitRegistry.registerByPredicate((class_1309 entity) -> entity instanceof class_1481 && entity.method_6109(), PreyTrait.ofHunterClass(class_4019.class));
        TraitRegistry.registerByClass(class_1428.class, PreyTrait.ofHunterClass(class_3701.class));
        TraitRegistry.registerByPredicate((class_1309 entity) -> entity instanceof class_1569 && !(entity instanceof class_1548), new PreyTrait(List.of(), List.of(), List.of(class_1439.class), List.of(), 3, 5));
        TraitRegistry.registerByClass(class_1473.class, new TemperatureTrait());
        TraitRegistry.registerByTag(class_3483.field_19168, RiderTrait.ofRideableClass(class_1584.class));
        TraitRegistry.registerByClass(class_1613.class, RiderTrait.ofRideableClass(class_1628.class));
        TraitRegistry.registerByPredicate((class_1309 entity) -> entity instanceof class_1569, new RiderTrait(List.of(rideable -> rideable instanceof class_1496 && rideable instanceof class_1569)));
        TraitRegistry.registerByClass(class_4985.class, new StandOnFluidTrait((class_6862<class_3611>)class_3486.field_15518));
        TraitRegistry.registerByClass(class_1634.class, new NoPhysicsTrait());
        TraitRegistry.registerByClass(class_1439.class, new CantSwimTrait());
        TraitRegistry.registerByClass(class_1439.class, new UndrownableTrait());
        TraitRegistry.registerByClass(class_1493.class, FearedTrait.ofFearfulClass(class_1547.class));
        TraitRegistry.registerByPredicate((class_1309 entity) -> entity instanceof class_3701 || entity instanceof class_1451, FearedTrait.ofFearfulClass(class_1548.class));
        TraitRegistry.registerByClass(class_3701.class, FearedTrait.ofFearfulClass(class_1428.class));
        TraitRegistry.registerByClass(class_1628.class, new ClimbBlocksTrait());
        TraitRegistry.registerByClass(class_1628.class, new ClimbBlocksTrait(List.of(class_2246.field_10343), new ArrayList<class_2248>()));
        TraitRegistry.registerByClass(class_1493.class, new ReinforcementsTrait());
        TraitRegistry.registerByClass(class_4466.class, new ReinforcementsTrait());
        TraitRegistry.registerByTag(class_3483.field_19168, new ReinforcementsTrait(32, new ArrayList(), List.of(class_3483.field_19168)));
        TraitRegistry.registerByClass(class_1481.class, new InstantDieOnDamageMsgTrait("lightningBolt"));
        TraitRegistry.registerByClass(class_1463.class, new PreyTrait(List.of(entity -> {
            class_1451 cat;
            return entity instanceof class_1451 && !(cat = (class_1451)entity).method_6181();
        })));
        TraitRegistry.registerByPredicate((class_1309 entity) -> entity.method_5864().method_5891().method_6133().contains("water") && entity.method_6094(), new AquaticTrait());
        TraitRegistry.registerByPredicate((class_1309 entity) -> entity.method_5864().method_5891().method_6133().contains("water") != entity.method_6094(), new AquaticTrait(true, true));
        TraitRegistry.registerByClass(class_1433.class, new AquaticTrait());
        TraitRegistry.registerByClass(class_1463.class, new WalkOnPowderSnow());
        TraitRegistry.registerByClass(class_1428.class, new SlowFallingTrait());
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("burns_in_daylight")), new BurnInDaylightTrait());
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("flying")), new FlyingTrait(false));
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("slow_falling")), new SlowFallingTrait());
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("wolf_prey")), PreyTrait.ofHunterClass(class_1493.class));
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("fox_prey")), PreyTrait.ofHunterClass(class_4019.class));
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("hurt_by_high_temperature")), new TemperatureTrait());
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("ravager_riding")), RiderTrait.ofRideableClass(class_1584.class));
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("lava_walking")), new StandOnFluidTrait((class_6862<class_3611>)class_3486.field_15518));
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("fall_through_blocks")), new NoPhysicsTrait());
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("cant_swim")), new CantSwimTrait());
        TraitRegistry.registerByTag(class_6862.method_40092((class_5321)Walkers.getEntityTypeRegistry().method_30517(), (class_2960)Walkers.id("undrownable")), new UndrownableTrait());
        TraitRegistry.registerByPredicate((class_1309 entity) -> entity.method_5864().method_5891().equals((Object)class_1311.field_6302), new AttackForHealthTrait());
        TraitRegistry.registerByPredicate((class_1309 entity) -> entity.method_5864().method_5891().equals((Object)class_1311.field_6302), new NocturnalTrait());
        TraitRegistry.registerByClass(class_3763.class, new CantInteractTrait(List.of(class_1646.class)));
        TraitRegistry.registerByClass(class_1528.class, new ImmunityTrait(class_1294.field_5920));
        TraitRegistry.registerByClass(class_1639.class, new ImmunityTrait(class_1294.field_5920));
        Integrations.registerTraits();
    }

    public static synchronized <L extends class_1309> List<ShapeTrait<L>> getAll(L shape) {
        ArrayList<ShapeTrait<L>> traits = new ArrayList<ShapeTrait<L>>();
        if (shape != null) {
            if (traitsByEntityTypes.containsKey(shape.method_5864())) {
                traits.addAll(traitsByEntityTypes.get(shape.method_5864()).stream().map(trait -> trait).toList());
            }
            for (Class<? extends class_1309> clazz : traitsByEntityClasses.keySet()) {
                if (!clazz.isInstance(shape)) continue;
                traits.addAll(traitsByEntityClasses.get(clazz).stream().map(trait -> trait).toList());
            }
            for (class_6862 class_68622 : traitsByEntityTags.keySet()) {
                if (!shape.method_5864().method_20210(class_68622)) continue;
                traits.addAll(traitsByEntityTags.get(class_68622).stream().map(trait -> trait).toList());
            }
            for (Predicate predicate : traitsByPredicates.keySet()) {
                if (!predicate.test(shape)) continue;
                traits.addAll(traitsByPredicates.get(predicate).stream().map(trait -> trait).toList());
            }
        }
        return traits;
    }

    public static synchronized <L extends class_1309> List<ShapeTrait<L>> get(L shape, class_2960 traitId) {
        List<ShapeTrait<L>> traits = TraitRegistry.getAll(shape);
        ArrayList<ShapeTrait<L>> filteredTraits = new ArrayList<ShapeTrait<L>>();
        for (ShapeTrait<L> trait : traits) {
            if (trait.getId() != traitId) continue;
            filteredTraits.add(trait);
        }
        return filteredTraits;
    }

    @ApiStatus.Experimental
    public static synchronized Map<ShapeTrait<?>, Predicate<class_1309>> getAllRegisteredById(class_2960 traitId) {
        HashMap traits = new HashMap();
        for (Map.Entry<class_1299<class_1309>, List<ShapeTrait<?>>> entry : traitsByEntityTypes.entrySet()) {
            for (ShapeTrait<?> trait : entry.getValue()) {
                if (trait.getId() != traitId) continue;
                traits.put(trait, entity -> entity.method_5864().equals(traitList.getKey()));
            }
        }
        for (Map.Entry<Object, List<ShapeTrait<?>>> entry : traitsByEntityClasses.entrySet()) {
            for (ShapeTrait<?> trait : entry.getValue()) {
                if (trait.getId() != traitId) continue;
                traits.put(trait, entity -> ((Class)traitList.getKey()).isInstance(entity));
            }
        }
        for (Map.Entry<Object, List<ShapeTrait<?>>> entry : traitsByEntityTags.entrySet()) {
            for (ShapeTrait<?> trait : entry.getValue()) {
                if (trait.getId() != traitId) continue;
                traits.put(trait, entity -> entity.method_5864().method_20210((class_6862)traitList.getKey()));
            }
        }
        for (Map.Entry<Object, List<ShapeTrait<?>>> entry : traitsByPredicates.entrySet()) {
            for (ShapeTrait<?> trait : entry.getValue()) {
                if (trait.getId() != traitId) continue;
                traits.put(trait, (Predicate)entry.getKey());
            }
        }
        return traits;
    }

    public static <A extends class_1309> void registerByType(class_1299<A> type, ShapeTrait<A> trait) {
        TraitRegistry.registerByType(type, List.of(trait));
    }

    public static <A extends class_1309> void registerByType(class_1299<A> type, List<ShapeTrait<A>> newtraits) {
        List<Object> traits = traitsByEntityTypes.containsKey(type) ? traitsByEntityTypes.get(type) : new ArrayList();
        for (ShapeTrait trait : newtraits) {
            if (!trait.canBeRegisteredMultipleTimes() && !traits.stream().noneMatch(entry -> entry.getId().equals((Object)trait.getId()))) continue;
            traits.add(trait);
        }
        traitsByEntityTypes.put(type, traits);
    }

    public static <A extends class_1309> void registerByTag(class_6862<class_1299<?>> tag, ShapeTrait<A> trait) {
        TraitRegistry.registerByTag(tag, List.of(trait));
    }

    public static <A extends class_1309> void registerByTag(class_6862<class_1299<?>> tag, List<ShapeTrait<A>> newtraits) {
        List<Object> traits = traitsByEntityTags.containsKey(tag) ? traitsByEntityTags.get(tag) : new ArrayList();
        for (ShapeTrait trait : newtraits) {
            if (!trait.canBeRegisteredMultipleTimes() && !traits.stream().noneMatch(entry -> entry.getId().equals((Object)trait.getId()))) continue;
            traits.add(trait);
        }
        traitsByEntityTags.put(tag, traits);
    }

    public static <A extends class_1309> void registerByClass(Class<A> entityClass, ShapeTrait<A> trait) {
        TraitRegistry.registerByClass(entityClass, List.of(trait));
    }

    public static <A extends class_1309> void registerByClass(Class<A> entityClass, List<ShapeTrait<A>> newtraits) {
        List<Object> traits = traitsByEntityClasses.containsKey(entityClass) ? traitsByEntityClasses.get(entityClass) : new ArrayList();
        for (ShapeTrait trait : newtraits) {
            if (!trait.canBeRegisteredMultipleTimes() && !traits.stream().noneMatch(entry -> entry.getId().equals((Object)trait.getId()))) continue;
            traits.add(trait);
        }
        traitsByEntityClasses.put(entityClass, traits);
    }

    public static void registerByPredicate(Predicate<class_1309> entityPredicate, ShapeTrait<?> trait) {
        TraitRegistry.registerByPredicate(entityPredicate, List.of(trait));
    }

    public static void registerByPredicate(Predicate<class_1309> entityPredicate, List<ShapeTrait<?>> newTraits) {
        List<Object> traits = traitsByPredicates.containsKey(entityPredicate) ? traitsByPredicates.get(entityPredicate) : new ArrayList();
        for (ShapeTrait<?> trait : newTraits) {
            if (!trait.canBeRegisteredMultipleTimes() && !traits.stream().noneMatch(entry -> entry.getId().equals((Object)trait.getId()))) continue;
            traits.add(trait);
        }
        traitsByPredicates.put(entityPredicate, traits);
    }

    public static void registerCodec(class_2960 traitId, MapCodec<? extends ShapeTrait<?>> traitCodec) {
        traitCodecById.put(traitId, traitCodec);
        traitIdByCodec.put(traitCodec, traitId);
    }

    @Nullable
    public static MapCodec<? extends ShapeTrait<?>> getTraitCodec(class_2960 traitId) {
        return traitCodecById.get(traitId);
    }

    @Nullable
    public static class_2960 getTraitId(MapCodec<? extends ShapeTrait<?>> traitCodec) {
        return traitIdByCodec.get(traitCodec);
    }

    public static <L extends class_1309> boolean has(L shape, class_2960 traitId) {
        if (shape != null) {
            if (traitsByEntityTypes.containsKey(shape.method_5864()) && traitsByEntityTypes.get(shape.method_5864()).stream().anyMatch(trait -> trait.getId() == traitId)) {
                return true;
            }
            for (Class<? extends class_1309> clazz : traitsByEntityClasses.keySet()) {
                if (!clazz.isInstance(shape) || !traitsByEntityClasses.get(clazz).stream().anyMatch(trait -> trait.getId() == traitId)) continue;
                return true;
            }
            for (class_6862 class_68622 : traitsByEntityTags.keySet()) {
                if (!shape.method_5864().method_20210(class_68622) || !traitsByEntityTags.get(class_68622).stream().anyMatch(trait -> trait.getId() == traitId)) continue;
                return true;
            }
            for (Predicate predicate : traitsByPredicates.keySet()) {
                if (!predicate.test(shape) || !traitsByPredicates.get(predicate).stream().anyMatch(trait -> trait.getId() == traitId)) continue;
                return true;
            }
        }
        return false;
    }

    public static void clearAll() {
        traitsByEntityTypes.clear();
        traitsByEntityClasses.clear();
        traitsByEntityTags.clear();
        traitsByPredicates.clear();
    }

    public static Codec<ShapeTrait<?>> getTraitCodec() {
        Codec codec = class_2960.field_25139.flatXmap(resourceLocation -> Optional.ofNullable(TraitRegistry.getTraitCodec(resourceLocation)).map(DataResult::success).orElseGet(() -> Walkers.dataError("Unknown shape trait: " + String.valueOf(resourceLocation))), traitCodec -> Optional.ofNullable(TraitRegistry.getTraitId(traitCodec)).map(DataResult::success).orElseGet(() -> Walkers.dataError("Unknown shape trait codec: " + String.valueOf(traitCodec))));
        return codec.dispatchStable(ShapeTrait::codec, MapCodec::codec);
    }
}

