/*
 * Decompiled with CFR 0.152.
 */
package tocraft.walkers.ability;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1428;
import net.minecraft.class_1430;
import net.minecraft.class_1438;
import net.minecraft.class_1454;
import net.minecraft.class_1463;
import net.minecraft.class_1472;
import net.minecraft.class_1473;
import net.minecraft.class_1481;
import net.minecraft.class_1493;
import net.minecraft.class_1496;
import net.minecraft.class_1501;
import net.minecraft.class_1510;
import net.minecraft.class_1528;
import net.minecraft.class_1545;
import net.minecraft.class_1548;
import net.minecraft.class_1559;
import net.minecraft.class_1560;
import net.minecraft.class_1564;
import net.minecraft.class_1571;
import net.minecraft.class_1606;
import net.minecraft.class_1613;
import net.minecraft.class_1627;
import net.minecraft.class_1640;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1847;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3483;
import net.minecraft.class_4466;
import net.minecraft.class_5354;
import net.minecraft.class_6053;
import net.minecraft.class_6862;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;
import tocraft.walkers.ability.ShapeAbility;
import tocraft.walkers.ability.impl.generic.ClearEffectsAbility;
import tocraft.walkers.ability.impl.generic.ExplosionAbility;
import tocraft.walkers.ability.impl.generic.GetItemAbility;
import tocraft.walkers.ability.impl.generic.JumpAbility;
import tocraft.walkers.ability.impl.generic.RandomTeleportationAbility;
import tocraft.walkers.ability.impl.generic.SaturateAbility;
import tocraft.walkers.ability.impl.generic.ShootDragonFireball;
import tocraft.walkers.ability.impl.generic.ShootFireballAbility;
import tocraft.walkers.ability.impl.generic.ShootSnowballAbility;
import tocraft.walkers.ability.impl.generic.TeleportationAbility;
import tocraft.walkers.ability.impl.generic.ThrowPotionsAbility;
import tocraft.walkers.ability.impl.specific.AngerAbility;
import tocraft.walkers.ability.impl.specific.ChickenAbility;
import tocraft.walkers.ability.impl.specific.EvokerAbility;
import tocraft.walkers.ability.impl.specific.LlamaAbility;
import tocraft.walkers.ability.impl.specific.PufferfishAbility;
import tocraft.walkers.ability.impl.specific.RabbitAbility;
import tocraft.walkers.ability.impl.specific.RaidAbility;
import tocraft.walkers.ability.impl.specific.SheepAbility;
import tocraft.walkers.ability.impl.specific.ShulkerAbility;
import tocraft.walkers.ability.impl.specific.TurtleAbility;
import tocraft.walkers.ability.impl.specific.WitherAbility;
import tocraft.walkers.integrations.Integrations;

public class AbilityRegistry {
    private static final Map<Predicate<class_1309>, ShapeAbility<?>> specificAbilities = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<Predicate<class_1309>, GenericShapeAbility<?>> genericAbilities = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<class_2960, MapCodec<? extends GenericShapeAbility<?>>> abilityCodecById = new HashMap();
    private static final Map<MapCodec<? extends GenericShapeAbility<?>>, class_2960> abilityIdByCodec = new IdentityHashMap();

    public static void initialize() {
        AbilityRegistry.registerCodec(ShootFireballAbility.ID, ShootFireballAbility.CODEC);
        AbilityRegistry.registerCodec(ClearEffectsAbility.ID, ClearEffectsAbility.CODEC);
        AbilityRegistry.registerCodec(ExplosionAbility.ID, ExplosionAbility.CODEC);
        AbilityRegistry.registerCodec(ShootDragonFireball.ID, ShootDragonFireball.CODEC);
        AbilityRegistry.registerCodec(TeleportationAbility.ID, TeleportationAbility.CODEC);
        AbilityRegistry.registerCodec(RandomTeleportationAbility.ID, RandomTeleportationAbility.CODEC);
        AbilityRegistry.registerCodec(JumpAbility.ID, JumpAbility.CODEC);
        AbilityRegistry.registerCodec(ThrowPotionsAbility.ID, ThrowPotionsAbility.CODEC);
        AbilityRegistry.registerCodec(SaturateAbility.ID, SaturateAbility.CODEC);
        AbilityRegistry.registerCodec(ShootSnowballAbility.ID, ShootSnowballAbility.CODEC);
        AbilityRegistry.registerCodec(GetItemAbility.ID, GetItemAbility.CODEC);
    }

    public static void registerDefault() {
        AbilityRegistry.registerByPredicate(livingEntity -> livingEntity instanceof class_5354, new AngerAbility());
        AbilityRegistry.registerByPredicate(entity -> entity.method_5864().method_20210(class_3483.field_19168), new RaidAbility());
        AbilityRegistry.registerByClass(class_1496.class, new JumpAbility());
        AbilityRegistry.registerByClass(class_1545.class, new ShootFireballAbility(class_1802.field_8183, false));
        AbilityRegistry.registerByPredicate(entity -> entity instanceof class_1548 && !((class_1548)entity).method_6872(), new ExplosionAbility());
        AbilityRegistry.registerByPredicate(entity -> entity instanceof class_1548 && ((class_1548)entity).method_6872(), new ExplosionAbility(6.0f));
        AbilityRegistry.registerByClass(class_1510.class, new ShootDragonFireball());
        AbilityRegistry.registerByClass(class_1560.class, new TeleportationAbility());
        AbilityRegistry.registerByClass(class_1571.class, new ShootFireballAbility(class_1802.field_8814, true));
        AbilityRegistry.registerByClass(class_1473.class, new ShootSnowballAbility());
        AbilityRegistry.registerByClass(class_1528.class, new WitherAbility());
        AbilityRegistry.registerByClass(class_1430.class, new ClearEffectsAbility());
        AbilityRegistry.registerByClass(class_6053.class, new ClearEffectsAbility());
        AbilityRegistry.registerByClass(class_1559.class, new RandomTeleportationAbility());
        AbilityRegistry.registerByClass(class_1501.class, new LlamaAbility());
        AbilityRegistry.registerByClass(class_1640.class, new ThrowPotionsAbility());
        AbilityRegistry.registerByClass(class_1564.class, new EvokerAbility());
        AbilityRegistry.registerByClass(class_1493.class, new AngerAbility(class_3417.field_14922, class_3417.field_14575));
        AbilityRegistry.registerByClass(class_1472.class, new SheepAbility());
        AbilityRegistry.registerByClass(class_1428.class, new ChickenAbility());
        AbilityRegistry.registerByClass(class_1438.class, new SaturateAbility());
        AbilityRegistry.registerByClass(class_4466.class, new AngerAbility(class_3417.field_20605, class_3417.field_20604));
        AbilityRegistry.registerByClass(class_1606.class, new ShulkerAbility());
        AbilityRegistry.registerByClass(class_1454.class, new PufferfishAbility());
        AbilityRegistry.registerByClass(class_1481.class, new TurtleAbility());
        AbilityRegistry.registerByClass(class_1463.class, new RabbitAbility());
        AbilityRegistry.registerByClass(class_1613.class, new GetItemAbility(new class_1799((class_1935)class_1802.field_8107, 4)));
        class_1799 slownessArrows = new class_1799((class_1935)class_1802.field_8087, 4);
        class_1799 poisonedArrows = new class_1799((class_1935)class_1802.field_8087, 4);
        class_1844.method_8061((class_1799)slownessArrows, (class_1842)class_1847.field_8996);
        class_1844.method_8061((class_1799)poisonedArrows, (class_1842)class_1847.field_8982);
        AbilityRegistry.registerByClass(class_1627.class, new GetItemAbility(slownessArrows));
        Integrations.registerAbilities();
        for (GenericShapeAbility<?> ability : genericAbilities.values()) {
            if (!abilityCodecById.containsKey(ability.getId())) {
                Walkers.LOGGER.warn("{} isn't registered!", (Object)ability.getId());
            }
            if (ability.getId() != null && ability.codec() != null) continue;
            Walkers.LOGGER.warn("{} isn't correctly setup!", (Object)ability.getClass().getSimpleName());
        }
    }

    public static <L extends class_1309> ShapeAbility<L> get(L shape) {
        if (Walkers.CONFIG.abilityBlacklist.contains(class_1299.method_5890((class_1299)shape.method_5864()).toString())) {
            return null;
        }
        ShapeAbility<?> ability = null;
        for (Map.Entry<Predicate<class_1309>, ShapeAbility<?>> entry : specificAbilities.entrySet()) {
            if (!entry.getKey().test(shape)) continue;
            ability = entry.getValue();
        }
        for (Map.Entry<Predicate<class_1309>, ShapeAbility<?>> entry : genericAbilities.entrySet()) {
            if (!entry.getKey().test(shape)) continue;
            ability = entry.getValue();
        }
        return ability;
    }

    public static <A extends class_1309> void registerByType(class_1299<A> type, ShapeAbility<A> ability) {
        AbilityRegistry.registerByPredicate(livingEntity -> type.equals(livingEntity.method_5864()), ability);
    }

    public static void registerByTag(class_6862<class_1299<?>> entityTag, ShapeAbility<class_1309> ability) {
        AbilityRegistry.registerByPredicate(livingEntity -> livingEntity.method_5864().method_20210(entityTag), ability);
    }

    public static <A extends class_1309> void registerByClass(Class<A> entityClass, ShapeAbility<A> ability) {
        AbilityRegistry.registerByPredicate(entityClass::isInstance, ability);
    }

    public static void registerByPredicate(Predicate<class_1309> entityPredicate, ShapeAbility<?> ability) {
        if (ability instanceof GenericShapeAbility) {
            GenericShapeAbility genericShapeAbility = (GenericShapeAbility)ability;
            genericAbilities.put(entityPredicate, genericShapeAbility);
        } else {
            specificAbilities.put(entityPredicate, ability);
        }
    }

    public static <L extends class_1309> boolean has(L shape) {
        if (Walkers.CONFIG.abilityBlacklist.contains(class_1299.method_5890((class_1299)shape.method_5864()).toString())) {
            return false;
        }
        return specificAbilities.keySet().stream().anyMatch(predicate -> predicate.test(shape)) || genericAbilities.keySet().stream().anyMatch(predicate -> predicate.test(shape));
    }

    public static void clearAll() {
        specificAbilities.clear();
        genericAbilities.clear();
    }

    public static void registerCodec(class_2960 abilityId, MapCodec<? extends GenericShapeAbility<?>> abilityCodec) {
        abilityCodecById.put(abilityId, abilityCodec);
        abilityIdByCodec.put(abilityCodec, abilityId);
    }

    @Nullable
    public static MapCodec<? extends GenericShapeAbility<?>> getAbilityCodec(class_2960 abilityId) {
        return abilityCodecById.get(abilityId);
    }

    @Nullable
    public static class_2960 getAbilityId(MapCodec<? extends GenericShapeAbility<?>> traitCodec) {
        return abilityIdByCodec.get(traitCodec);
    }

    public static Codec<GenericShapeAbility<?>> getAbilityCodec() {
        Codec codec = class_2960.field_25139.flatXmap(resourceLocation -> Optional.ofNullable(AbilityRegistry.getAbilityCodec(resourceLocation)).map(DataResult::success).orElseGet(() -> Walkers.dataError("Unknown shape ability: " + String.valueOf(resourceLocation))), abilityCodec -> Optional.ofNullable(AbilityRegistry.getAbilityId(abilityCodec)).map(DataResult::success).orElseGet(() -> Walkers.dataError("Unknown shape ability codec: " + String.valueOf(abilityCodec))));
        return codec.dispatchStable(GenericShapeAbility::codec, MapCodec::codec);
    }
}

