package tocraft.walkers.traits.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

import java.util.ArrayList;
import java.util.List;

@SuppressWarnings("unused")
public class CantInteractTrait<E extends class_1309> extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("cant_interact");
    public static final MapCodec<CantInteractTrait<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            Codec.BOOL.optionalFieldOf("can_only_interact_with_listed", false).forGetter(o -> o.canOnlyInteractWithListed),
            Codec.list(class_2960.field_25139).optionalFieldOf("types", new ArrayList<>()).forGetter(o -> o.types.stream().map(o1 -> class_1299.method_5890(o1)).toList()),
            Codec.list(class_2960.field_25139).optionalFieldOf("tags", new ArrayList<>()).forGetter(o -> o.tags.stream().map(class_6862::comp_327).toList())
    ).apply(instance, instance.stable((canOnlyInteractWithListed, typeIds, tagIds) -> {
        List<class_1299<?>> reinforcements = new ArrayList<>();
        List<class_6862<class_1299<?>>> reinforcementTags = new ArrayList<>();
        for (class_2960 resourceLocation : typeIds) {
            if (Walkers.getEntityTypeRegistry().method_10250(resourceLocation)) {
                reinforcements.add(Walkers.getEntityTypeRegistry().method_10223(resourceLocation));
            }
        }
        for (class_2960 resourceLocation : tagIds) {
            reinforcementTags.add(class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), resourceLocation));
        }
        return new CantInteractTrait<>(canOnlyInteractWithListed, reinforcements, reinforcementTags);
    })));
    private final boolean canOnlyInteractWithListed;
    private final List<Class<? extends class_1297>> classes;
    private final List<class_1299<?>> types;
    private final List<class_6862<class_1299<?>>> tags;

    public CantInteractTrait(@NotNull List<class_1299<?>> types, @NotNull List<class_6862<class_1299<?>>> tags) {
        this(false, new ArrayList<>(), types, tags);
    }

    public CantInteractTrait(boolean canOnlyInteractWithListed, @NotNull List<class_1299<?>> types, @NotNull List<class_6862<class_1299<?>>> tags) {
        this(canOnlyInteractWithListed, new ArrayList<>(), types, tags);
    }

    public CantInteractTrait(@NotNull List<Class<? extends class_1297>> classes) {
        this(false, classes, new ArrayList<>(), new ArrayList<>());
    }

    public CantInteractTrait(boolean canOnlyInteractWithListed, @NotNull List<Class<? extends class_1297>> classes) {
        this(canOnlyInteractWithListed, classes, new ArrayList<>(), new ArrayList<>());
    }

    public CantInteractTrait(@NotNull List<Class<? extends class_1297>> classes, @NotNull List<class_1299<?>> types, @NotNull List<class_6862<class_1299<?>>> tags) {
        this(false, classes, types, tags);
    }

    public CantInteractTrait(boolean canOnlyInteractWithListed, @NotNull List<Class<? extends class_1297>> classes, @NotNull List<class_1299<?>> types, @NotNull List<class_6862<class_1299<?>>> tags) {
        this.canOnlyInteractWithListed = canOnlyInteractWithListed;
        this.classes = classes;
        this.types = types;
        this.tags = tags;
    }

    public boolean canInteractWithEntity(class_1297 entity) {
        boolean bool = false;
        for (Class<? extends class_1297> clazz : classes) {
            if (clazz.isInstance(entity)) {
                bool = true;
                break;
            }
        }

        if (types.contains(entity.method_5864())) {
            bool = true;
        }

        for (class_6862<class_1299<?>> tag : tags) {
            if (entity.method_5864().method_20210(tag)) {
                bool = true;
                break;
            }
        }

        return bool == this.canOnlyInteractWithListed;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public @Nullable class_1058 getIcon() {
        class_1087 itemModel = class_310.method_1551().method_1480().method_4012().method_3304(class_1802.field_8371);
        if (itemModel != null) {
            return itemModel.method_4711();
        } else {
            return super.getIcon();
        }
    }
}
