package tocraft.walkers.screen.hud;

import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_490;
//#if MC>1194
import net.minecraft.client.gui.GuiGraphics;
//#if MC>1182
import org.joml.Quaternionf;
//#else
//$$ import com.mojang.math.Quaternion;
//#endif
//#if MC>1201
import org.joml.Vector3f;
//#endif
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.patched.client.CGraphics;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

import java.util.HashMap;
import java.util.Map;

public class VariantMenu {
    private final Map<ShapeType<?>, class_1309> renderEntities = new HashMap<>();
    private final Map<ShapeType<?>, class_1309> renderSpecialEntities = new HashMap<>();

    //#if MC>1194
    public void render(GuiGraphics guiGraphics) {
        //#else
        //$$ public void render(PoseStack guiGraphics) {
        //#endif
        class_310 minecraft = class_310.method_1551();
        if (!minecraft.field_1690.field_1842 && WalkersClient.isRenderingVariantsMenu && Walkers.CONFIG.unlockEveryVariant && minecraft.field_1755 == null) {
            class_1937 level = minecraft.field_1687;
            if (level != null && minecraft.field_1724 != null) {
                ShapeType<?> currentShapeType = ShapeType.from(PlayerShape.getCurrentShape(minecraft.field_1724));
                if (currentShapeType != null) {
                    boolean hasSpecialVariant = Walkers.hasSpecialShape(minecraft.field_1724.method_5667()) && class_1299.method_5890(currentShapeType.getEntityType()).equals(Identifier.parse("minecraft:wolf"));

                    int currentVariantId = currentShapeType.getVariantData();

                    // get range of variants
                    TypeProvider<?> typeProvider = TypeProviderRegistry.getProvider(currentShapeType.getEntityType());
                    int range = typeProvider != null ? typeProvider.getRange() : -1;
                    // add special shape as extra variant
                    if (hasSpecialVariant) {
                        range++;
                        class_1309 currentShape = PlayerShape.getCurrentShape(minecraft.field_1724);
                        if (currentShape != null) {
                            class_2487 nbt = new class_2487();
                            currentShape.method_5647(nbt);
                            if (nbt.method_10545("isSpecial") && nbt.method_10577("isSpecial")) {
                                currentVariantId = range;
                            }
                        }
                    }

                    // get data of menu
                    int x = minecraft.method_22683().method_4486() / 7;
                    int y = minecraft.method_22683().method_4502() / 5;
                    // render transparent background
                    CGraphics.fillTransparent(guiGraphics, x, 0, x * 6, y + 10);
                    // render entities
                    if (range > -1) {
                        WalkersClient.variantOffset = class_3532.method_15340(WalkersClient.variantOffset, -currentVariantId - (hasSpecialVariant ? 1 : 0), range - currentVariantId);
                        for (int i = 1; i <= 5; i++) {
                            int thisVariantId = currentVariantId - 3 + i + WalkersClient.variantOffset;
                            class_1309 entity = null;
                            // special shape is rendered as an extra variant
                            if (hasSpecialVariant && thisVariantId == range) {
                                entity = renderSpecialEntities.computeIfAbsent(currentShapeType, type -> {
                                    class_2487 nbt = new class_2487();

                                    nbt.method_10556("isSpecial", true);
                                    nbt.method_10582("id", class_1299.method_5890(type.getEntityType()).toString());
                                    return (class_1309) class_1299.method_17842(nbt, level, it -> it);
                                });
                            } else if ((thisVariantId > -1 || (hasSpecialVariant && thisVariantId == -1)) && (thisVariantId <= range || thisVariantId == currentVariantId)) {
                                ShapeType<?> thisShapeType = ShapeType.from(currentShapeType.getEntityType(), thisVariantId);
                                if (thisShapeType != null) {
                                    entity = renderEntities.computeIfAbsent(thisShapeType, type -> type.create(level, minecraft.field_1724));
                                }
                            }
                            if (entity != null) {
                                //#if MC>1201
                                class_490.method_2486(guiGraphics, (float) x * i + (float) x / 2, (float) y * .75f, (int) (25 * (1 / (Math.max(entity.method_17682(), entity.method_17681())))), new Vector3f(), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
                                //#elseif MC>1182
                                //$$ InventoryScreen.renderEntityInInventory(guiGraphics, (int) ((float) x * i + (float) x / 2), (int) ((float) y * .75f), (int) (25 * (1 / (Math.max(entity.getBbHeight(), entity.getBbWidth())))), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
                                //#else
                                //$$ InventoryScreen.renderEntityInInventory((int) ((float) x * i + (float) x / 2), (int) ((float) y * .75f), (int) (25 * (1 / (Math.max(entity.getBbHeight(), entity.getBbWidth())))), -10, -10, entity);
                                //#endif
                            }
                        }
                    } else {
                        class_1309 entity = renderEntities.computeIfAbsent(currentShapeType, type -> type.create(level, minecraft.field_1724));
                        if (entity != null) {
                            //#if MC>1201
                            class_490.method_2486(guiGraphics, (float) x * 3 + (float) x / 2, (float) y * .75f, (int) (25 * (1 / (Math.max(entity.method_17682(), entity.method_17681())))), new Vector3f(), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
                            //#elseif MC>1182
                            //$$ InventoryScreen.renderEntityInInventory(guiGraphics, (int) ((float) x * 3 + (float) x / 2), (int) ((float) y * .75f), (int) (25 * (1 / (Math.max(entity.getBbHeight(), entity.getBbWidth())))), new Quaternionf().rotationXYZ(0.43633232F, (float) Math.PI, (float) Math.PI), null, entity);
                            //#else
                            //$$ InventoryScreen.renderEntityInInventory((int) ((float) x * 3 + (float) x / 2), (int) ((float) y * .75f), (int) (25 * (1 / (Math.max(entity.getBbHeight(), entity.getBbWidth())))), -10, -10, entity);
                            //#endif
                        }
                    }
                    // render focus
                    CGraphics.blit(guiGraphics, Walkers.id("textures/gui/focused.png"), x * 3, 5, x, y, 0, 0, 48, 32, 48, 32);
                }
            }
        }
    }
}
