package tocraft.walkers.registry;

import net.minecraft.class_1267;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1496;
import net.minecraft.class_1588;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_2509;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.craftedcore.event.common.PlayerEvents;
import tocraft.craftedcore.event.common.ResourceEvents;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.FlightHelper;
import tocraft.walkers.api.PlayerHostility;
import tocraft.walkers.api.PlayerShape;
//#if MC>=1205
import tocraft.walkers.impl.variant.WolfTypeProvider;
//#endif
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.CantInteractTrait;
import tocraft.walkers.traits.impl.NocturnalTrait;
import tocraft.walkers.traits.impl.RiderTrait;

@SuppressWarnings("resource")
public class WalkersEventHandlers {

    public static void initialize() {
        registerHostilityUpdateHandler();
        registerEntityRidingHandler();
        registerPlayerRidingHandler();
        registerLivingDeathHandler();

        // set WolfTypeProvider Range when on server
        //#if MC>=1205
        ResourceEvents.DATA_PACK_SYNC.register(player -> WolfTypeProvider.setRange(CEntity.level(player)));
        //#endif

        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null) {
                for (ShapeTrait<class_1309> skill : TraitRegistry.get(shape, CantInteractTrait.ID)) {
                    if (!((CantInteractTrait<class_1309>) skill).canInteractWithEntity(entity)) {
                        return class_1269.field_5814;
                    }
                }
            }

            return class_1269.field_5811;
        });

        PlayerEvents.ALLOW_SLEEP_TIME.register((player, sleepingPos, vanillaResult) -> {
            if (TraitRegistry.has(PlayerShape.getCurrentShape(player), NocturnalTrait.ID)) {
                return CEntity.level(player).method_8530() ? class_1269.field_5812 : class_1269.field_5814;
            }
            return class_1269.field_5811;
        });

        PlayerEvents.SLEEP_FINISHED_TIME.register((level, newTime) -> {
            if (level.method_8530() && !level.method_18766(player -> player.method_6113() && TraitRegistry.has(PlayerShape.getCurrentShape(player), NocturnalTrait.ID)).isEmpty()) {
                return newTime + level.method_8532() % 24000L > 12000L ? 13000 : -11000;
            } else {
                return newTime;
            }
        });

        PlayerEvents.AWARD_ADVANCEMENT.register((player, advancement, criterionKey) -> {
            if (Walkers.hasFlyingPermissions(player)) {
                FlightHelper.grantFlightTo(player);
                FlightHelper.updateFlyingSpeed(player);
                player.method_7355();
            }
        });
    }

    public static void registerHostilityUpdateHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            if (!CEntity.level(player).field_9236 && Walkers.CONFIG.playerCanTriggerHostiles && entity instanceof class_1588) {
                PlayerHostility.set(player, Walkers.CONFIG.hostilityTime);
            }

            return class_1269.field_5811;
        });
    }

    // Players with an equipped Walkers inside the `ravager_riding` entity tag
// should
// be able to ride Ravagers.
    public static void registerEntityRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            class_1309 shape = PlayerShape.getCurrentShape(player);
            if (shape != null && entity instanceof class_1309 livingEntity) {
                // checks, if selected entity is rideable
                for (RiderTrait<?> riderTrait : TraitRegistry.get(shape, RiderTrait.ID).stream().map(entry -> (RiderTrait<?>) entry).toList()) {
                    if (riderTrait.isRideable(livingEntity) || (livingEntity instanceof class_1657 rideablePlayer && riderTrait.isRideable(PlayerShape.getCurrentShape(rideablePlayer)))) {
                        player.method_5804(entity);
                        return class_1269.field_5811;
                    }
                }
            }
            return class_1269.field_5811;
        });
    }

    // make this server-side
    public static void registerPlayerRidingHandler() {
        EntityEvents.INTERACT_WITH_PLAYER.register((player, entity, hand) -> {
            if (entity instanceof class_1657 playerToBeRidden) {
                if (PlayerShape.getCurrentShape(playerToBeRidden) instanceof class_1496) {
                    player.method_5873(playerToBeRidden, true);
                }
            }
            return class_1269.field_5811;
        });
    }

    public static void registerLivingDeathHandler() {
        EntityEvents.LIVING_DEATH.register((entity, damageSource) -> {
            if (!CEntity.level(entity).method_8608()) {
                if (entity instanceof class_1646 villager && damageSource.method_5529() instanceof class_1657 player && PlayerShape.getCurrentShape(player) instanceof class_1642) {
                    if (!(CEntity.level(player).method_8407() != class_1267.field_5807 && player.method_6051().nextBoolean())) {
                        class_1641 zombievillager = villager.method_29243(class_1299.field_6054, false);
                        if (zombievillager != null) {
                            //#if MC>=1205
                            zombievillager.method_5943((class_5425) CEntity.level(player), CEntity.level(player).method_8404(zombievillager.method_24515()), class_3730.field_16468, new class_1642.class_1644(false, true));
                            zombievillager.method_16916(villager.method_8264());
                            //#else
                            //$$ zombievillager.finalizeSpawn((ServerLevelAccessor) CEntity.level(player), CEntity.level(player).getCurrentDifficultyAt(zombievillager.blockPosition()), MobSpawnType.CONVERSION, new Zombie.ZombieGroupData(false, true), null);
                            //$$ zombievillager.setTradeOffers(villager.getOffers().createTag());
                            //#endif
                            zombievillager.method_7195(villager.method_7231());
                            //#if MC>1182
                            zombievillager.method_21649(villager.method_21651().method_19067(class_2509.field_11560));
                            //#else
                            //$$ zombievillager.setGossips(villager.getGossips().store(NbtOps.INSTANCE).getValue());
                            //#endif
                            zombievillager.method_19622(villager.method_19269());
                        }
                    }
                }
            }
            return class_1269.field_5811;
        });
    }
}
