package tocraft.walkers.network.impl;

import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.mixin.EntityTrackerAccessor;
import tocraft.walkers.mixin.ThreadedAnvilChunkStorageAccessor;
import tocraft.walkers.network.NetworkHandler;

import java.util.UUID;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3222;

public class VehiclePackets {
    public static void handleSyncPacket(ModernNetworking.Context context, class_2487 tag) {
        if (context.getPlayer() != null && tag != null) {
            UUID sender = tag.method_25926("senderID");
            class_1657 commandSender = context.getPlayer().method_5770().method_18470(sender);
            if (commandSender != null) {
                UUID playerVehicleID = tag.method_10577("isRidingPlayer") ? tag.method_25926("playerVehicleID") : null;

                ((PlayerDataProvider) commandSender).walkers$setVehiclePlayerUUID(playerVehicleID);
            }
        }
    }

    public static void sync(class_3222 player) {
        class_2487 tag = new class_2487();
        boolean isRidingPlayer = player.method_5854() instanceof class_3222;
        tag.method_25927("senderID", player.method_5667());
        tag.method_10556("isRidingPlayer", isRidingPlayer);

        if (isRidingPlayer) tag.method_25927("playerVehicleID", player.method_5854().method_5667());

        Int2ObjectMap<Object> trackers = ((ThreadedAnvilChunkStorageAccessor) ((class_3218) CEntity.level(player)).method_14178().field_17254).getEntityMap();
        Object tracking = trackers.get(player.method_5628());
        // Send to all clients
        if (tracking != null)
            ((EntityTrackerAccessor) tracking).getSeenBy().forEach(listener -> {
                ModernNetworking.sendToPlayer(listener.method_32311(), NetworkHandler.CHANGE_VEHICLE_STATE, tag.method_10553());
            });
    }
}
