package tocraft.walkers.network.impl;

import net.minecraft.class_2487;
import net.minecraft.class_3222;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.walkers.api.platform.ApiLevel;
import tocraft.walkers.network.NetworkHandler;

public class SyncApiLevelPackets {
    public static void handleSyncPacket(class_2487 nbt) {
        if (nbt != null) {
            String apiLevelId = nbt.method_10558("api_level");
            ApiLevel apiLevel = ApiLevel.valueOf(apiLevelId);
            ApiLevel.ON_API_LEVEL_CHANGE_EVENT.invoke().setServerApiLevel(apiLevel);
        }
    }

    public static void sendSyncPacket(class_3222 player) {
        class_2487 nbt = new class_2487();
        nbt.method_10582("api_level", ApiLevel.getCurrentLevel().name());

        // Send to client
        ModernNetworking.sendToPlayer(player, NetworkHandler.SYNC_API_LEVEL, nbt);
    }
}
