package tocraft.walkers.mixin.integrations.client;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;

@SuppressWarnings("UnresolvedMixinReference")
@Pseudo
@Environment(EnvType.CLIENT)
@Mixin(targets = "net.bettercombat.compatibility.CompatibilityFlags", remap = false)
public class BetterCombatMixin {
    @Inject(method = "firstPersonRender", at = @At("RETURN"), cancellable = true)
    private static void onFirstPersonRenderCall(CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = class_310.method_1551().field_1724;
        if (player != null && PlayerShape.getCurrentShape(player) != null) {
            cir.setReturnValue(false);
        }
    }
}
