package tocraft.walkers.mixin;

import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Mutable;
import org.spongepowered.asm.mixin.Shadow;
import tocraft.walkers.api.PlayerShape;

import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1429;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_4019;

@Mixin(class_4019.class)
public abstract class FoxEntityMixin extends class_1429 {

    @Shadow
    @Final
    @Mutable
    private static Predicate<class_1297> AVOID_PLAYERS;

    private FoxEntityMixin(class_1299<? extends class_1429> entityType, class_1937 world) {
        super(entityType, world);
    }

    // Change the default "flee from player," predicate to ignore players disguised
    // as Foxes.
    // Hopefully nobody else needs to modify fox fleeing behavior.
    static {
        AVOID_PLAYERS = entity -> {
            boolean isShapedPlayer = false;

            if (entity instanceof class_1657 player) {
                class_1309 shape = PlayerShape.getCurrentShape(player);
                if (shape instanceof class_4019) {
                    isShapedPlayer = true;
                }
            }

            return !entity.method_21751() && class_1301.field_6156.test(entity) && !isShapedPlayer;
        };
    }
}
