//#if MC>=1205
package tocraft.walkers.impl.variant;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1493;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.core.registries.Registries;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.WolfVariants;
import tocraft.craftedcore.patched.TComponent;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.api.variant.TypeProvider;

import java.util.Objects;

@SuppressWarnings("resource")
public class WolfTypeProvider extends TypeProvider<class_1493> {
    private static int range = 9;

    public WolfTypeProvider() {
        if (PlatformData.getEnv() == EnvType.CLIENT) {
            setClientRange();
        }
    }

    @Environment(EnvType.CLIENT)
    private static void setClientRange() {
        class_1937 clientLevel = class_310.method_1551().field_1687;
        if (clientLevel != null) {
            setRange(clientLevel);
        }
    }

    @Override
    public int getVariantData(class_1493 entity) {
        setRange(entity.level());
        return entity.level().registryAccess().registryOrThrow(Registries.WOLF_VARIANT).getId(entity.getVariant().value());
    }

    @Override
    public class_1493 create(class_1299<class_1493> type, class_1937 level, int data) {
        setRange(level);

        class_1493 wolf = type.method_5883(level);
        if (wolf != null) {
            class_2378<WolfVariant> wolfVariantRegistry = level.method_30349().method_30530(Registries.WOLF_VARIANT);
            wolf.setVariant(wolfVariantRegistry.getHolder(data).orElse(wolfVariantRegistry.getHolderOrThrow(WolfVariants.PALE)));
        }
        return wolf;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return range;
    }

    public static void setRange(class_1937 level) {
        range = level.method_30349().method_30530(Registries.WOLF_VARIANT).size() - 1;
    }

    @Override
    public class_2561 modifyText(class_1493 entity, class_5250 text) {
        setRange(entity.level());
        return TComponent.literal(formatTypePrefix(Objects.requireNonNull(entity.level().registryAccess().registryOrThrow(Registries.WOLF_VARIANT).getKey(entity.getVariant().value())).getPath()) + " ").append(text);
    }
}
//#endif
