//#if MC>1182
package tocraft.walkers.impl.tick.shapes;

import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.world.entity.animal.frog.Frog;
import tocraft.craftedcore.patched.CEntity;
import tocraft.walkers.api.WalkersTickHandler;

public class FrogTickHandler implements WalkersTickHandler<Frog> {

    @Override
    public void tick(class_1657 player, Frog frog) {
        if (CEntity.level(player).field_9236) {
            boolean walk = CEntity.isOnGround(player) && player.method_18798().method_37268() > 1.0E-6 && !player.method_5816();
            boolean swim = player.method_18798().method_37268() > 1.0E-6 && player.method_5816();

            // Jumping
            if (!CEntity.isOnGround(player) && !swim && !walk && !player.method_5816()) {
                frog.jumpAnimationState.startIfStopped(frog.tickCount);
            } else {
                frog.jumpAnimationState.stop();
            }

            // Swimming
            if (swim) {
                frog.swimIdleAnimationState.stop();
            } else if (player.method_5816()) {
                frog.swimIdleAnimationState.startIfStopped(frog.tickCount);
            } else {
                frog.swimIdleAnimationState.stop();
            }

            // Random croaking
            if (CEntity.level(player).field_9229.nextDouble() <= 0.001) {
                frog.croakAnimationState.start(player.field_6012);
            }

            // Tongue
            if (player.field_6252) {
                frog.tongueAnimationState.startIfStopped(player.field_6012);
            } else {
                frog.tongueAnimationState.stop();
            }
        } else {
            // Buffs - jump boost
            player.method_6092(new class_1293(class_1294.field_5913, 20 * 2, 2, true, false));
        }
    }
}
//#endif
