package tocraft.walkers.command;

import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2321;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
//#if MC>1182
import net.minecraft.commands.CommandBuildContext;
import tocraft.craftedcore.patched.CEntitySummonArgument;
import tocraft.craftedcore.patched.TComponent;
import tocraft.walkers.Walkers;

import static tocraft.craftedcore.patched.CCommandSourceStack.sendSuccess;

public class EntityBlacklistCommands {
    //#if MC>1182
    public static LiteralCommandNode<class_2168> getRootNode(CommandBuildContext ctx) {
        //#else
        //$$ public static LiteralCommandNode<CommandSourceStack> getRootNode() {
        //$$     // just 'coz I'm lazy
        //$$     Object ctx = null;
        //#endif
        LiteralCommandNode<class_2168> rootNode = class_2170.method_9247("entityBlacklist").build();

        LiteralCommandNode<class_2168> addToList = class_2170.method_9247("add")
                .then(class_2170.method_9244("entity", CEntitySummonArgument.id(ctx)).suggests(class_2321.field_10935)
                        .executes(context -> {
                            addToList(context.getSource(), CEntitySummonArgument.getEntityTypeId(context, "entity"));
                            return 1;
                        }))
                .build();
        LiteralCommandNode<class_2168> removeFromList = class_2170.method_9247("remove")
                .then(class_2170.method_9244("entity", CEntitySummonArgument.id(ctx)).suggests(class_2321.field_10935)
                        .executes(context -> {
                            removeFromList(context.getSource(), CEntitySummonArgument.getEntityTypeId(context, "entity"));
                            return 1;
                        }))
                .build();

        LiteralCommandNode<class_2168> listList = class_2170.method_9247("list")
                .executes(context -> listEntities(context.getSource()))
                .build();

        LiteralCommandNode<class_2168> clearList = class_2170.method_9247("clear")
                .executes(context -> clearEntities(context.getSource()))
                .build();


        LiteralCommandNode<class_2168> isWhitelist = class_2170.method_9247("isWhitelist")
                .executes(context -> {
                    isWhitelist(context.getSource());
                    return 1;
                })
                .then(class_2170.method_9244("value", BoolArgumentType.bool())
                        .executes(context -> {
                            setIsWhitelist(context.getSource(), BoolArgumentType.getBool(context, "value"));
                            return 1;
                        }))
                .build();

        rootNode.addChild(listList);
        rootNode.addChild(clearList);
        rootNode.addChild(addToList);
        rootNode.addChild(removeFromList);
        rootNode.addChild(isWhitelist);
        return rootNode;
    }

    private static void isWhitelist(class_2168 source) {
        sendSuccess(source, TComponent.translatable("craftedcore.config.get", "entityBlacklistIsWhitelist", Walkers.CONFIG.entityBlacklistIsWhitelist), false);
    }

    private static void setIsWhitelist(class_2168 source, boolean value) {
        Walkers.CONFIG.entityBlacklistIsWhitelist = value;
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        sendSuccess(source, TComponent.translatable("craftedcore.config.set", "entityBlacklistIsWhitelist", String.valueOf(value)), false);
    }

    private static int clearEntities(class_2168 source) {
        Walkers.CONFIG.entityBlacklist.clear();
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        sendSuccess(source, TComponent.translatable("walkers.entityBlacklist.clear"), false);

        return 1;
    }

    private static int listEntities(class_2168 source) {
        for (String s : Walkers.CONFIG.entityBlacklist) {
            sendSuccess(source, TComponent.translatable("walkers.entityBlacklist.list", s), false);
        }

        if (Walkers.CONFIG.entityBlacklist.isEmpty()) {
            sendSuccess(source, TComponent.translatable("walkers.entityBlacklist.isEmpty"), false);
        }

        return 1;
    }

    private static void addToList(class_2168 source, class_2960 type) {
        Walkers.CONFIG.entityBlacklist.add(type.toString());
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        sendSuccess(source, TComponent.translatable("walkers.entityBlacklist.add", type.toString()), false);
    }

    private static void removeFromList(class_2168 source, class_2960 type) {
        Walkers.CONFIG.entityBlacklist.remove(type.toString());
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        sendSuccess(source, TComponent.translatable("walkers.entityBlacklist.remove", type.toString()), false);
    }
}
