package tocraft.walkers.api.data.abilities;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import tocraft.craftedcore.data.SynchronizedJsonReloadListener;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.craftedcore.platform.PlatformData;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.AbilityRegistry;
import tocraft.walkers.ability.GenericShapeAbility;
import tocraft.walkers.ability.ShapeAbility;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

public class AbilityDataManager extends SynchronizedJsonReloadListener {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, new class_2960.class_2961()).create();

    public AbilityDataManager() {
        super(GSON, Walkers.MODID + "/abilities");
    }

    @SuppressWarnings("unchecked")
    @Override
    protected void onApply(Map<class_2960, JsonElement> map) {
        // prevent duplicates and the registration of removed entries
        AbilityRegistry.clearAll();
        AbilityRegistry.registerDefault();

        for (Map.Entry<class_2960, JsonElement> mapEntry : map.entrySet()) {
            //#if MC>=1205
            AbilityList abilityList = ABILITY_LIST_CODEC.parse(JsonOps.INSTANCE, mapEntry.getValue().getAsJsonObject()).getOrThrow(msg -> {
                throw new JsonParseException(msg);
            });
            //#else
            //$$ AbilityList abilityList = ABILITY_LIST_CODEC.parse(JsonOps.INSTANCE, mapEntry.getValue().getAsJsonObject()).getOrThrow(false, msg -> {
            //$$     throw new JsonParseException(msg);
            //$$ });
            //#endif

            if (!abilityList.isEmpty()) {
                if (abilityList.requiredMod() == null || abilityList.requiredMod().isBlank() || PlatformData.isModLoaded(abilityList.requiredMod())) {
                    // entity types
                    for (class_1299<class_1309> entityType : abilityList.entityTypes()) {
                        AbilityRegistry.registerByType(entityType, (GenericShapeAbility<class_1309>) abilityList.ability());
                    }

                    if (!abilityList.entityTypes().isEmpty()) {
                        logRegistration(abilityList.entityTypes(), abilityList.ability());
                    }

                    // entity tags
                    for (class_6862<class_1299<?>> entityTag : abilityList.entityTags()) {
                        AbilityRegistry.registerByTag(entityTag, (GenericShapeAbility<class_1309>) abilityList.ability());
                    }

                    if (!abilityList.entityTags().isEmpty()) {
                        logRegistration(abilityList.entityTags(), abilityList.ability());
                    }
                }
            }
        }
    }

    private static void logRegistration(Object key, ShapeAbility<?> ability) {
        Walkers.LOGGER.info("{}: {} registered for {}", AbilityDataManager.class.getSimpleName(), key, ability.getClass().getSimpleName());
    }

    public static Codec<AbilityList> ABILITY_LIST_CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.STRING.optionalFieldOf("required_mod", "").forGetter(AbilityList::requiredMod),
            Codec.list(class_2960.field_25139).optionalFieldOf("entity_types", new ArrayList<>()).forGetter(AbilityList::entityTypeKeys),
            Codec.list(class_2960.field_25139).optionalFieldOf("entity_tags", new ArrayList<>()).forGetter(AbilityList::entityTagKeys),
            AbilityRegistry.getAbilityCodec().fieldOf("ability").forGetter(AbilityList::ability)
    ).apply(instance, instance.stable(AbilityList::new)));

    @SuppressWarnings("unused")
    public record AbilityList(String requiredMod, List<class_2960> entityTypeKeys,
                              List<class_2960> entityTagKeys,
                              GenericShapeAbility<?> ability) {

        public AbilityList(List<class_1299<?>> entityTypeKeys, List<class_6862<class_1299<?>>> entityTagKeys, GenericShapeAbility<?> ability, String requiredMod) {
            this(requiredMod, entityTypeKeys.stream().map(class_1299::method_5890).toList(), entityTagKeys.stream().map(class_6862::comp_327).toList(), ability);
        }

        @SuppressWarnings("unchecked")
        public List<class_1299<class_1309>> entityTypes() {
            return entityTypeKeys.stream().filter(Walkers.getEntityTypeRegistry()::method_10250).map(type -> (class_1299<class_1309>) Walkers.getEntityTypeRegistry().method_10223(type)).toList();
        }

        public List<class_6862<class_1299<?>>> entityTags() {
            return entityTagKeys().stream().map(tag -> class_6862.method_40092(Walkers.getEntityTypeRegistry().method_30517(), tag)).toList();
        }

        public boolean isEmpty() {
            return entityTypeKeys().isEmpty() && entityTagKeys().isEmpty();
        }
    }
}
