//#if MC>1194
package tocraft.walkers.ability.impl.specific;

import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_3419;
import net.minecraft.core.registries.BuiltInRegistries;
import tocraft.craftedcore.patched.CEntity;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.ability.ShapeAbility;

import java.util.ArrayList;
import java.util.List;

public class SnifferAbility<T extends class_1308> extends ShapeAbility<T> {

    @Override
    public void onUse(class_1657 player, T shape, class_1937 world) {
        // Ensures, the player isn't in Water/Lava and touches the ground
        if (player.method_5771() || player.method_5799() || !CEntity.isOnGround(player))
            return;

        class_2338 playerPos = player.method_24515();
        class_2338 blockPos = new class_2338(playerPos.method_10263(), playerPos.method_10264() - 1, playerPos.method_10260());
        List<class_2248> diggableBlocks = new ArrayList<>();
        diggableBlocks.add(BuiltInRegistries.BLOCK.get(Identifier.parse("minecraft:dirt")));
        diggableBlocks.add(BuiltInRegistries.BLOCK.get(Identifier.parse("minecraft:grass_block")));
        diggableBlocks.add(BuiltInRegistries.BLOCK.get(Identifier.parse("minecraft:podzol")));
        diggableBlocks.add(BuiltInRegistries.BLOCK.get(Identifier.parse("minecraft:rooted_dirt")));
        diggableBlocks.add(BuiltInRegistries.BLOCK.get(Identifier.parse("minecraft:moss_block")));
        diggableBlocks.add(BuiltInRegistries.BLOCK.get(Identifier.parse("minecraft:mud")));
        diggableBlocks.add(BuiltInRegistries.BLOCK.get(Identifier.parse("minecraft:muddy_mangrove_roots")));

        // checks, if the block bellow the player is in the 'diggableBlocks'-List
        if (diggableBlocks.contains(world.method_8320(blockPos).method_26204()) && Math.random() <= 0.5D) {
            // drop Item
            if (getRandomBoolean())
                player.method_5706(Items.TORCHFLOWER_SEEDS);
            else
                player.method_5706(Items.PITCHER_POD);

            world.method_8449(null, player, SoundEvents.SNIFFER_DIGGING, class_3419.field_15248, 1.0F, (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F + 1.0F);
        } else
            world.method_8449(null, player, SoundEvents.SNIFFER_DIGGING_STOP, class_3419.field_15248, 1.0F, (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F + 1.0F);
    }

    @Override
    public class_1792 getIcon() {
        return Items.TORCHFLOWER;
    }

    private static boolean getRandomBoolean() {
        return Math.random() < 0.5;
    }

    @Override
    public int getDefaultCooldown() {
        return 9600;
    }
}
//#endif
