package tocraft.walkers.ability.impl.generic;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;
import tocraft.craftedcore.patched.CRegistries;
import tocraft.craftedcore.patched.Identifier;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

import java.util.Optional;
import net.minecraft.class_1308;
import net.minecraft.class_1545;
import net.minecraft.class_1571;
import net.minecraft.class_1657;
import net.minecraft.class_1674;
import net.minecraft.class_1677;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3855;

public class ShootFireballAbility<T extends class_1308> extends GenericShapeAbility<T> {
    public static final class_2960 ID = Walkers.id("shoot_fireball");
    @SuppressWarnings("unchecked")
    public static final MapCodec<ShootFireballAbility<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            class_2960.field_25139.optionalFieldOf("icon").forGetter(o -> {
                if (o.icon == class_1802.field_8814) return Optional.empty();
                else
                    return Optional.ofNullable(((class_2378<class_1792>) CRegistries.getRegistry(Identifier.parse("item"))).method_10221(o.icon));
            }),
            Codec.BOOL.fieldOf("is_large").forGetter(o -> o.isLarge)
    ).apply(instance, instance.stable((icon, isLarge) -> icon.<ShootFireballAbility<?>>map(resourceLocation -> new ShootFireballAbility<>(((class_2378<class_1792>) CRegistries.getRegistry(Identifier.parse("item"))).method_10223(resourceLocation), isLarge)).orElseGet(() -> new ShootFireballAbility<>(isLarge)))));

    private final boolean isLarge;
    private final class_1792 icon;

    public ShootFireballAbility(boolean isLarge) {
        this(class_1802.field_8814, isLarge);
    }

    public ShootFireballAbility(class_1792 icon, boolean isLarge) {
        this.icon = icon;
        this.isLarge = isLarge;
    }


    @Override
    public void onUse(class_1657 player, class_1308 shape, class_1937 world) {
        class_3855 fireball = getFireball(player, world);
        world.method_8649(fireball);
        if (shape instanceof class_1545) {
            world.method_8449(null, player, class_3417.field_14970, class_3419.field_15251, 2.0F, (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F + 1.0F);
        } else if (shape instanceof class_1571) {
            world.method_8449(null, player, class_3417.field_15231, class_3419.field_15251, 10.0F, (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F + 1.0F);
            world.method_8449(null, player, class_3417.field_15130, class_3419.field_15251, 10.0F, (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F + 1.0F);
        } else {
            world.method_8449(null, player, class_3417.field_15013, class_3419.field_15251, 2.0F, (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F + 1.0F);
        }
    }

    private @NotNull class_3855 getFireball(class_1657 player, class_1937 world) {
        class_3855 fireball;
        if (isLarge) {
            //#if MC>1206
            fireball = new class_1674(
                    world,
                    player,
                    new class_243(player.method_5720().field_1352,
                            player.method_5720().field_1351,
                            player.method_5720().field_1350),
                    2);
            //#else
            //$$ fireball = new LargeFireball(
            //$$         world,
            //$$         player,
            //$$         player.getLookAngle().x,
            //$$         player.getLookAngle().y,
            //$$         player.getLookAngle().z,
            //$$         2);
            //#endif
            fireball.method_5808(fireball.method_23317(), fireball.method_23318() + 1.75, fireball.method_23321(), fireball.method_36454(), fireball.method_36455());
            fireball.method_30634(fireball.method_23317(), fireball.method_23318(), fireball.method_23321());
        } else {
            //#if MC>1206
            fireball = new class_1677(
                    world,
                    player.method_23317(),
                    player.method_23320(),
                    player.method_23321(),
                    new class_243(player.method_5720().field_1352,
                            player.method_5720().field_1351,
                            player.method_5720().field_1350));
            //#else
            //$$ fireball = new SmallFireball(
            //$$         world,
            //$$         player.getX(),
            //$$         player.getEyeY(),
            //$$         player.getZ(),
            //$$         player.getLookAngle().x,
            //$$         player.getLookAngle().y,
            //$$         player.getLookAngle().z);
            //#endif
        }

        fireball.method_7432(player);
        return fireball;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }

    @Override
    public class_1792 getIcon() {
        return icon;
    }
}
