package tocraft.walkers.ability.impl.generic;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import tocraft.walkers.Walkers;
import tocraft.walkers.ability.GenericShapeAbility;

public class SaturateAbility<T extends class_1308> extends GenericShapeAbility<T> {
    public static final class_2960 ID = Walkers.id("saturate");
    public static final MapCodec<SaturateAbility<?>> CODEC = RecordCodecBuilder.mapCodec((instance) -> instance.group(
            Codec.INT.optionalFieldOf("food_level", 6).forGetter(o -> o.foodLevel),
            Codec.FLOAT.optionalFieldOf("saturation_level", 0.1F).forGetter(o -> o.saturationLevel)
    ).apply(instance, instance.stable(SaturateAbility::new)));

    private final int foodLevel;
    private final float saturationLevel;

    public SaturateAbility() {
        this(6, 0.1F);
    }

    public SaturateAbility(int foodLevel, float saturationLevel) {
        this.foodLevel = foodLevel;
        this.saturationLevel = saturationLevel;
    }

    @Override
    public void onUse(class_1657 player, T shape, class_1937 world) {
        player.method_7344().method_7585(foodLevel, saturationLevel);

        world.method_8449(null, player, class_3417.field_14870, class_3419.field_15248, 1.0F, (world.field_9229.nextFloat() - world.field_9229.nextFloat()) * 0.2F + 1.0F);
    }

    @Override
    public class_1792 getIcon() {
        return class_1802.field_8208;
    }

    @Override
    public int getDefaultCooldown() {
        return 300;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public MapCodec<? extends GenericShapeAbility<?>> codec() {
        return CODEC;
    }
}
