package tocraft.walkers.traits.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import org.jetbrains.annotations.NotNull;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6862;

@SuppressWarnings("unused")
public class FearedTrait<E extends class_1309> extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("feared");
    public static final Codec<FearedTrait<?>> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.list(class_2960.field_25139).optionalFieldOf("fearful", new ArrayList<>()).forGetter(o -> o.fearfulTypes.stream().map(class_2378.field_11145::method_10221).toList()),
            Codec.list(class_2960.field_25139).optionalFieldOf("fearful_tags", new ArrayList<>()).forGetter(o -> o.fearfulTags.stream().map(class_6862::comp_327).toList())
    ).apply(instance, instance.stable((preyLocations, preyTagLocations) -> {
        List<class_1299<?>> fearfulTypes = new ArrayList<>();
        List<class_6862<class_1299<?>>> fearfulTags = new ArrayList<>();
        for (class_2960 resourceLocation : preyLocations) {
            if (class_2378.field_11145.method_10250(resourceLocation)) {
                fearfulTypes.add(class_2378.field_11145.method_10223(resourceLocation));
            }
        }
        for (class_2960 preyTagLocation : preyTagLocations) {
            fearfulTags.add(class_6862.method_40092(class_2378.field_25107, preyTagLocation));
        }
        return new FearedTrait<>(new ArrayList<>(), fearfulTypes, new ArrayList<>(), fearfulTags);
    })));

    private final List<Predicate<class_1309>> fearfulPredicates;
    private final List<class_1299<?>> fearfulTypes;
    private final List<Class<? extends class_1309>> fearfulClasses;
    private final List<class_6862<class_1299<?>>> fearfulTags;

    public static FearedTrait<?> ofFearfulType(class_1299<?>... fearful) {
        return new FearedTrait<>(new ArrayList<>(), List.of(fearful), new ArrayList<>(), new ArrayList<>());
    }

    @SafeVarargs
    public static FearedTrait<?> ofFearfulTag(class_6862<class_1299<?>>... fearful) {
        return new FearedTrait<>(new ArrayList<>(), new ArrayList<>(), new ArrayList<>(), List.of(fearful));
    }

    @SafeVarargs
    public static FearedTrait<?> ofFearfulClass(Class<? extends class_1309>... fearful) {
        return new FearedTrait<>(new ArrayList<>(), new ArrayList<>(), List.of(fearful), new ArrayList<>());
    }

    public FearedTrait(@NotNull List<Predicate<class_1309>> fearfulPredicates) {
        this(fearfulPredicates, new ArrayList<>(), new ArrayList<>(), new ArrayList<>());
    }

    public FearedTrait(@NotNull List<Predicate<class_1309>> fearfulPredicates, @NotNull List<class_1299<?>> fearfulTypes, @NotNull List<Class<? extends class_1309>> fearfulClasses, @NotNull List<class_6862<class_1299<?>>> fearfulTags) {
        this.fearfulPredicates = fearfulPredicates;
        this.fearfulTypes = fearfulTypes;
        this.fearfulClasses = fearfulClasses;
        this.fearfulTags = fearfulTags;
    }

    public boolean isFeared(class_1309 entity) {
        if (fearfulTypes.contains(entity.method_5864())) return true;
        for (Class<? extends class_1309> fearfulClass : fearfulClasses) {
            if (fearfulClass.isInstance(entity)) return true;
        }
        for (class_6862<class_1299<?>> fearfulTag : fearfulTags) {
            if (entity.method_5864().method_20210(fearfulTag)) return true;
        }
        for (Predicate<class_1309> fearfulPredicate : fearfulPredicates) {
            if (fearfulPredicate.test(entity)) return true;
        }
        return false;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Codec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }
}
