package tocraft.walkers.traits.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1309;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

import java.util.ArrayList;
import java.util.List;

public class ClimbBlocksTrait<E extends class_1309> extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("climb_blocks");
    public static final Codec<ClimbBlocksTrait<?>> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.BOOL.optionalFieldOf("horizontal_collision", true).forGetter(o -> o.horizontalCollision),
            Codec.list(class_2960.field_25139).optionalFieldOf("valid_blocks", new ArrayList<>()).forGetter(o -> o.validBlocks.stream().map(class_2378.field_11146::method_10221).toList()),
            Codec.list(class_2960.field_25139).optionalFieldOf("invalid_blocks", new ArrayList<>()).forGetter(o -> o.invalidBlocks.stream().map(class_2378.field_11146::method_10221).toList())
    ).apply(instance, instance.stable((horizontalCollision, validBlocksLocation, invalidBlocksLocation) -> {
        List<class_2248> validBlocks = new ArrayList<>();
        for (class_2960 resourceLocation : validBlocksLocation) {
            if (class_2378.field_11146.method_10250(resourceLocation)) {
                validBlocks.add(class_2378.field_11146.method_10223(resourceLocation));
            }
        }
        List<class_2248> invalidBlocks = new ArrayList<>();
        for (class_2960 resourceLocation : invalidBlocksLocation) {
            if (class_2378.field_11146.method_10250(resourceLocation)) {
                validBlocks.add(class_2378.field_11146.method_10223(resourceLocation));
            }
        }
        return new ClimbBlocksTrait<>(horizontalCollision, validBlocks, invalidBlocks);
    })));

    public final boolean horizontalCollision;
    public final List<class_2248> validBlocks;
    public final List<class_2248> invalidBlocks;

    public ClimbBlocksTrait() {
        this(true);
    }

    public ClimbBlocksTrait(boolean horizontalCollision) {
        this(horizontalCollision, new ArrayList<>(), new ArrayList<>());
    }

    public ClimbBlocksTrait(List<class_2248> validBlocks, List<class_2248> invalidBlocks) {
        this(false, validBlocks, invalidBlocks);

    }

    public ClimbBlocksTrait(boolean horizontalCollision, List<class_2248> validBlocks, List<class_2248> invalidBlocks) {
        this.horizontalCollision = horizontalCollision;
        this.validBlocks = validBlocks;
        this.invalidBlocks = invalidBlocks;
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Codec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public @Nullable class_1058 getIcon() {
        return class_310.method_1551().method_1541().method_3351().method_3335(class_2246.field_10597.method_9564()).method_4711();
    }
}
