package tocraft.walkers.traits.impl;

import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.Walkers;
import tocraft.walkers.traits.ShapeTrait;

import java.util.Optional;

public class AquaticTrait<E extends class_1309> extends ShapeTrait<E> {
    public static final class_2960 ID = Walkers.id("aquatic");
    public static final Codec<AquaticTrait<?>> CODEC = RecordCodecBuilder.create((instance) -> instance.group(
            Codec.INT.optionalFieldOf("is_aquatic").forGetter(o -> Optional.empty()),
            Codec.BOOL.optionalFieldOf("isAquatic", true).forGetter(o -> o.isAquatic),
            Codec.BOOL.optionalFieldOf("isLand", false).forGetter(o -> o.isLand)
    ).apply(instance, instance.stable((i, isAquatic, isLand) -> {
        if (i.isPresent()) {
            switch (i.get()) {
                case 0 -> {
                    return new AquaticTrait<>(true, false);
                }
                case 1 -> {
                    return new AquaticTrait<>(true, true);
                }
                case 2 -> {
                    return new AquaticTrait<>(false, true);
                }
            }
        }
        return new AquaticTrait<>(isAquatic, isLand);
    })));

    public final boolean isAquatic;
    public final boolean isLand;

    public AquaticTrait(boolean isAquatic, boolean isLand) {
        this.isAquatic = isAquatic;
        this.isLand = isLand;
    }

    public AquaticTrait(boolean isAquatic) {
        this(isAquatic, !isAquatic);
    }

    public AquaticTrait() {
        this(true, false);
    }

    @Override
    public class_2960 getId() {
        return ID;
    }

    @Override
    public Codec<? extends ShapeTrait<?>> codec() {
        return CODEC;
    }

    @Override
    @Environment(EnvType.CLIENT)
    public @Nullable class_1058 getIcon() {
        if (isAquatic && !isLand) {
            class_1087 itemIcon = class_310.method_1551().method_1480().method_4012().method_3304(class_1802.field_8207);
            if (itemIcon != null) {
                return itemIcon.method_4711();
            }
        } else if (isAquatic) {
            return class_310.method_1551().method_18505().method_18663(class_1294.field_5923);
        }
        return super.getIcon();
    }
}
