package tocraft.walkers.screen.hud;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.*;
import net.minecraft.class_1159;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2487;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_490;
import net.minecraft.class_5253;
import net.minecraft.class_757;
import tocraft.walkers.Walkers;
import tocraft.walkers.WalkersClient;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.api.variant.ShapeType;
import tocraft.walkers.api.variant.TypeProvider;
import tocraft.walkers.api.variant.TypeProviderRegistry;

public class VariantMenu {
    public void render(class_4587 matrices) {
        class_310 minecraft = class_310.method_1551();
        if (!minecraft.field_1690.field_1842 && WalkersClient.isRenderingVariantsMenu && Walkers.CONFIG.unlockEveryVariant && minecraft.field_1755 == null) {
            class_1937 level = minecraft.field_1687;
            if (level != null && minecraft.field_1724 != null) {
                ShapeType<?> currentShapeType = ShapeType.from(PlayerShape.getCurrentShape(minecraft.field_1724));
                if (currentShapeType != null) {
                    boolean hasSpecialVariant = Walkers.hasSpecialShape(minecraft.field_1724.method_5667()) && class_2378.field_11145.method_10221(currentShapeType.getEntityType()).equals(new class_2960("minecraft:wolf"));

                    int currentVariantId = currentShapeType.getVariantData();

                    // get range of variants
                    TypeProvider<?> typeProvider = TypeProviderRegistry.getProvider(currentShapeType.getEntityType());
                    int range = typeProvider != null ? typeProvider.getRange() : -1;
                    // add special shape as extra variant
                    if (hasSpecialVariant) {
                        range++;
                        class_1309 currentShape = PlayerShape.getCurrentShape(minecraft.field_1724);
                        if (currentShape != null) {
                            class_2487 nbt = new class_2487();
                            currentShape.method_5647(nbt);
                            if (nbt.method_10545("isSpecial") && nbt.method_10577("isSpecial")) {
                                currentVariantId = range;
                            }
                        }
                    }

                    // get data of menu
                    int x = minecraft.method_22683().method_4486() / 7;
                    int y = minecraft.method_22683().method_4502() / 5;
                    // render transparent background
                    BackportedGraphicTools.fillGradient(matrices, x, 0, x * 6, y + 10, -1072689136, -804253680);
                    // render entities
                    if (range > -1) {
                        WalkersClient.variantOffset = class_3532.method_15340(WalkersClient.variantOffset, -currentVariantId - (hasSpecialVariant ? 1 : 0), range - currentVariantId);
                        for (int i = 1; i <= 5; i++) {
                            int thisVariantId = currentVariantId - 3 + i + WalkersClient.variantOffset;
                            class_1309 entity = null;
                            // special shape is rendered as an extra variant
                            if (hasSpecialVariant && thisVariantId == range) {
                                class_2487 nbt = new class_2487();

                                nbt.method_10556("isSpecial", true);
                                nbt.method_10582("id", class_2378.field_11145.method_10221(currentShapeType.getEntityType()).toString());
                                entity = (class_1309) class_1299.method_17842(nbt, level, it -> it);
                            } else if ((thisVariantId > -1 || (hasSpecialVariant && thisVariantId == -1)) && (thisVariantId <= range || thisVariantId == currentVariantId)) {
                                ShapeType<?> thisShapeType = ShapeType.from(currentShapeType.getEntityType(), thisVariantId);
                                if (thisShapeType != null) {
                                    entity = thisShapeType.create(level, minecraft.field_1724);
                                }
                            }
                            if (entity != null) {
                                class_490.method_2486((int) ((float) x * i + (float) x / 2), (int) ((float) y * .75f), (int) (25 * (1 / (Math.max(entity.method_17682(), entity.method_17681())))), -10, -10, entity);
                            }
                        }
                    } else {
                        class_1309 entity = currentShapeType.create(level);
                        if (entity != null) {
                            class_490.method_2486((int) ((float) x * 3 + (float) x / 2), (int) ((float) y * .75f), (int) (25 * (1 / (Math.max(entity.method_17682(), entity.method_17681())))), -10, -10, entity);
                        }
                    }
                    // render focus
                    RenderSystem.setShaderTexture(0, Walkers.id("textures/gui/focused.png"));
                    class_332.method_25293(matrices, x * 3, 5, x, y, 0, 0, 48, 32, 48, 32);
                }
            }
        }
    }

    private static class BackportedGraphicTools {
        protected static void fillGradient(class_4587 poseStack, int x1, int y1, int x2, int y2, int colorFrom, int colorTo) {
            fillGradient(poseStack, x1, y1, x2, y2, colorFrom, colorTo, 0);
        }

        protected static void fillGradient(class_4587 poseStack, int x1, int y1, int x2, int y2, int colorFrom, int colorTo, int blitOffset) {
            RenderSystem.enableBlend();
            RenderSystem.setShader(class_757::method_34540);
            class_289 tesselator = class_289.method_1348();
            class_287 bufferBuilder = tesselator.method_1349();
            bufferBuilder.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
            fillGradient(poseStack.method_23760().method_23761(), bufferBuilder, x1, y1, x2, y2, blitOffset, colorFrom, colorTo);
            tesselator.method_1350();
            RenderSystem.disableBlend();
        }

        protected static void fillGradient(class_1159 matrix, class_287 builder, int x1, int y1, int x2, int y2, int blitOffset, int colorA, int colorB) {
            float f = (float) class_5253.class_5254.method_27762(colorA) / 255.0F;
            float g = (float) class_5253.class_5254.method_27765(colorA) / 255.0F;
            float h = (float) class_5253.class_5254.method_27766(colorA) / 255.0F;
            float i = (float) class_5253.class_5254.method_27767(colorA) / 255.0F;
            float j = (float) class_5253.class_5254.method_27762(colorB) / 255.0F;
            float k = (float) class_5253.class_5254.method_27765(colorB) / 255.0F;
            float l = (float) class_5253.class_5254.method_27766(colorB) / 255.0F;
            float m = (float) class_5253.class_5254.method_27767(colorB) / 255.0F;
            builder.method_22918(matrix, (float) x1, (float) y1, (float) blitOffset).method_22915(g, h, i, f).method_1344();
            builder.method_22918(matrix, (float) x1, (float) y2, (float) blitOffset).method_22915(k, l, m, j).method_1344();
            builder.method_22918(matrix, (float) x2, (float) y2, (float) blitOffset).method_22915(k, l, m, j).method_1344();
            builder.method_22918(matrix, (float) x2, (float) y1, (float) blitOffset).method_22915(g, h, i, f).method_1344();
        }
    }
}
