package tocraft.walkers.network;

import org.jetbrains.annotations.Nullable;
import tocraft.craftedcore.client.CraftedCoreClient;
import tocraft.craftedcore.network.ModernNetworking;
import tocraft.craftedcore.network.client.ClientNetworking.ApplicablePacket;
import tocraft.walkers.impl.DimensionsRefresher;
import tocraft.walkers.impl.PlayerDataProvider;
import tocraft.walkers.network.impl.SyncApiLevelPackets;
import tocraft.walkers.network.impl.UnlockPackets;
import tocraft.walkers.network.impl.VehiclePackets;

import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_2487;

public class ClientNetworking implements NetworkHandler {

    public static void registerPacketHandlers() {
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, NetworkHandler.SHAPE_SYNC,
                ClientNetworking::handleWalkersSyncPacket);
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, NetworkHandler.ABILITY_SYNC,
                ClientNetworking::handleAbilitySyncPacket);
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, NetworkHandler.UNLOCK_SYNC,
                UnlockPackets::handleUnlockSyncPacket);
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, NetworkHandler.CHANGE_VEHICLE_STATE,
                VehiclePackets::handleSyncPacket);
        ModernNetworking.registerReceiver(ModernNetworking.Side.S2C, NetworkHandler.SYNC_API_LEVEL,
                (context, nbt) -> SyncApiLevelPackets.handleSyncPacket(nbt));
    }

    public static void runOrQueue(ModernNetworking.Context context, ApplicablePacket packet) {
        if (context.getPlayer() == null) {
            CraftedCoreClient.getSyncPacketQueue().add(packet);
        } else {
            context.queue(() -> packet.apply(context.getPlayer()));
        }
    }

    public static void sendAbilityRequest() {
        ModernNetworking.sendToServer(USE_ABILITY, new class_2487());
    }

    public static void handleWalkersSyncPacket(ModernNetworking.Context context, class_2487 packetData) {
        final UUID uuid = packetData.method_25926("uuid");
        final String id = packetData.method_10558("type");
        final class_2487 entityNbt = packetData.method_10562("entity_tag");

        runOrQueue(context, player -> {
            @Nullable
            class_1657 syncTarget = player.method_5770().method_18470(uuid);

            if (syncTarget != null) {
                PlayerDataProvider data = (PlayerDataProvider) syncTarget;

                // set shape to null (no shape) if the entity id is "minecraft:empty"
                if (id.equals("minecraft:empty")) {
                    data.walkers$setCurrentShape(null);
                    ((DimensionsRefresher) syncTarget).shape_refreshDimensions();
                    return;
                }

                // If entity type was valid, deserialize entity data from tag/
                entityNbt.method_10582("id", id);
                Optional<class_1299<?>> type = class_1299.method_17684(entityNbt);
                if (type.isPresent()) {
                    class_1309 shape = data.walkers$getCurrentShape();

                    // ensure entity data exists
                    if (shape == null || !type.get().equals(shape.method_5864())) {
                        shape = (class_1309) type.get().method_5883(syncTarget.field_6002);
                        data.walkers$setCurrentShape(shape);

                        // refresh player dimensions/hitbox on client
                        ((DimensionsRefresher) syncTarget).shape_refreshDimensions();
                    }

                    if (shape != null) {
                        shape.method_5651(entityNbt);
                    }
                }
            }
        });
    }

    public static void handleAbilitySyncPacket(ModernNetworking.Context context, class_2487 packet) {
        int cooldown = packet.method_10550("cooldown");
        runOrQueue(context, player -> ((PlayerDataProvider) player).walkers$setAbilityCooldown(cooldown));
    }
}
