package tocraft.walkers.mixin.player;

import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_3414;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.mixin.LivingEntityMixin;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.mixin.accessor.MobEntityAccessor;

@Mixin(class_1657.class)
public abstract class PlayerSoundMixin extends LivingEntityMixin {

    protected PlayerSoundMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "getHurtSound", at = @At("HEAD"), cancellable = true)
    private void getHurtSound(class_1282 source, CallbackInfoReturnable<class_3414> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue(((LivingEntityAccessor) shape).callGetHurtSound(source));
        }
    }

    @Unique
    private int shape_ambientSoundChance = 0;

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickAmbientSounds(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (!field_6002.field_9236 && Walkers.CONFIG.playAmbientSounds && shape instanceof class_1308 mobShape) {

            if (this.method_5805() && this.field_5974.nextInt(1000) < this.shape_ambientSoundChance++) {
                // reset sound delay
                this.shape_ambientSoundChance = -mobShape.method_5970();

                // play ambient sound
                class_3414 sound = ((MobEntityAccessor) mobShape).callGetAmbientSound();
                if (sound != null) {
                    float volume = ((LivingEntityAccessor) mobShape).callGetSoundVolume();
                    float pitch = ((LivingEntityAccessor) mobShape).callGetVoicePitch();

                    // By default, players can not hear their own ambient noises.
                    // This is because ambient noises can be very annoying.
                    if (Walkers.CONFIG.hearSelfAmbient) {
                        this.field_6002.method_8465(null, this.method_23317(), this.method_23318(), this.method_23321(), sound,
                                this.method_5634(), volume, pitch);
                    } else {
                        this.field_6002.method_8465((class_1657) (Object) this, this.method_23317(), this.method_23318(), this.method_23321(), sound,
                                this.method_5634(), volume, pitch);
                    }
                }
            }
        }
    }

    @Inject(method = "getDeathSound", at = @At("HEAD"), cancellable = true)
    private void getDeathSound(CallbackInfoReturnable<class_3414> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue(((LivingEntityAccessor) shape).callGetDeathSound());
        }
    }

    @Inject(method = "getFallSounds", at = @At("HEAD"), cancellable = true)
    private void getFallSounds(CallbackInfoReturnable<class_1309.class_6823> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (Walkers.CONFIG.useShapeSounds && shape != null) {
            cir.setReturnValue(shape.method_39760());
        }
    }
}
