package tocraft.walkers.mixin.player;

import com.llamalad7.mixinextras.injector.v2.WrapWithCondition;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1439;
import net.minecraft.class_1454;
import net.minecraft.class_1584;
import net.minecraft.class_1621;
import net.minecraft.class_1628;
import net.minecraft.class_1639;
import net.minecraft.class_1657;
import net.minecraft.class_1690;
import net.minecraft.class_1702;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2668;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_4019;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4466;
import net.minecraft.class_5134;
import net.minecraft.world.entity.*;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.mixin.LivingEntityMixin;
import tocraft.walkers.mixin.accessor.EntityAccessor;
import tocraft.walkers.mixin.accessor.IronGolemEntityAccessor;
import tocraft.walkers.mixin.accessor.LivingEntityAccessor;
import tocraft.walkers.mixin.accessor.RavagerEntityAccessor;
import tocraft.walkers.traits.ShapeTrait;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.*;

import java.util.Iterator;

@SuppressWarnings({"RedundantCast", "DataFlowIssue"})
@Mixin(class_1657.class)
public abstract class PlayerEntityMixin extends LivingEntityMixin {
    private PlayerEntityMixin(class_1299<? extends class_1309> type, class_1937 world) {
        super(type, world);
    }

    @Inject(method = "getDimensions", at = @At("HEAD"), cancellable = true)
    private void getDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> cir) {
        class_1309 entity = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (entity != null) {
            class_4048 shapeDimensions = entity.method_18377(pose);
            if (pose == class_4050.field_18081 && TraitRegistry.has(entity, HumanoidTrait.ID)) {
                cir.setReturnValue(class_4048.method_18384(shapeDimensions.field_18067, shapeDimensions.field_18068 * 1.5F / 1.8F));
            } else {
                cir.setReturnValue(shapeDimensions);
            }
        }
    }


    @Inject(method = "getStandingEyeHeight", at = @At("HEAD"), cancellable = true)
    private void shape_getStandingEyeHeight(class_4050 pose, class_4048 dimensions, CallbackInfoReturnable<Float> cir) {
        // cursed
        try {
            class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

            if (shape != null) {
                cir.setReturnValue(((LivingEntityAccessor) shape).callGetEyeHeight(method_18376(), method_18377(method_18376())));
            }
        } catch (Exception ignored) {

        }
    }

    @Inject(method = "attack", at = @At("HEAD"))
    protected void shape_tryAttack(class_1297 target, CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape instanceof class_1439 golem) {
            ((IronGolemEntityAccessor) golem).setAttackTicksLeft(10);
        } else if (shape instanceof class_1584 ravager) {
            ((RavagerEntityAccessor) ravager).setAttackTick(10);
        } else if (shape instanceof class_1639 && target instanceof class_1309 livingTarget) {
            livingTarget.method_37222(new class_1293(class_1294.field_5920, 200), this);
        } else if (shape instanceof class_4466 bee && bee.method_29511() && target instanceof class_1309 livingTarget) {
            livingTarget.method_37222(new class_1293(class_1294.field_5899, 200), this);
        } else if (shape instanceof class_1454 pufferfish) {
            int i = pufferfish.method_6594();

            if (target instanceof class_1309 livingTarget) {
                if (livingTarget.method_5643(class_1282.method_5511((class_1657) (Object) this), (float) (1 + i))) {
                    livingTarget.method_37222(new class_1293(class_1294.field_5899, 60 * i, 0), (class_1657) (Object) this);
                    this.method_5783(class_3417.field_14848, 1.0F, 1.0F);

                    if (livingTarget instanceof class_3222 serverPlayerTarget && !this.method_5701()) {
                        serverPlayerTarget.field_13987.method_14364(new class_2668(class_2668.field_25654, 0.0F));
                    }
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickGolemAttackTicks(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape instanceof class_1439 golem) {
            IronGolemEntityAccessor accessor = (IronGolemEntityAccessor) golem;
            if (accessor.getAttackTicksLeft() > 0) {
                accessor.setAttackTicksLeft(accessor.getAttackTicksLeft() - 1);
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickRavagerAttackTicks(CallbackInfo ci) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);

        if (shape instanceof class_1584 ravager) {
            RavagerEntityAccessor accessor = (RavagerEntityAccessor) ravager;
            if (accessor.getAttackTick() > 0) {
                accessor.setAttackTick(accessor.getAttackTick() - 1);
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickFire(CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        class_1309 shape = PlayerShape.getCurrentShape(player);

        if (!player.field_6002.field_9236 && !player.method_7337() && !player.method_7325()) {
            // check if the player is shape
            if (shape != null) {
                // check if the player's current shape burns in sunlight
                if (TraitRegistry.has(shape, BurnInDaylightTrait.ID)) {
                    boolean bl = this.walkers$isInDaylight();
                    // handle night burning
                    for (BurnInDaylightTrait<?> trait : TraitRegistry.get(shape, BurnInDaylightTrait.ID).stream().map(trait -> ((BurnInDaylightTrait<?>) trait)).toList()) {
                        bl = (bl && !trait.burnInMoonlightInstead) || (!this.walkers$isInDaylight() && trait.burnInMoonlightInstead);
                    }
                    if (bl) {

                        // Can't burn in the rain
                        if (player.field_6002.method_8419()) {
                            return;
                        }

                        // check for helmets to negate burning
                        class_1799 itemStack = player.method_6118(class_1304.field_6169);
                        if (!itemStack.method_7960()) {
                            if (itemStack.method_7963()) {

                                // damage stack instead of burning player
                                itemStack.method_7974(itemStack.method_7919() + player.method_6051().nextInt(2));
                                if (itemStack.method_7919() >= itemStack.method_7936()) {
                                    player.method_20235(class_1304.field_6169);
                                    player.method_5673(class_1304.field_6169, class_1799.field_8037);
                                }
                            }

                            bl = false;
                        }

                        // set player on fire
                        if (bl) {
                            player.method_5639(8);
                        }
                    }
                }
            }
        }
    }

    @Unique
    private boolean walkers$isInDaylight() {
        if (field_6002.method_8530() && !field_6002.field_9236) {
            float brightnessAtEyes = method_5718();
            class_2338 daylightTestPosition = new class_2338(method_23317(), (double) Math.round(method_23318()), method_23321());

            // move test position up one block for boats
            if (method_5854() instanceof class_1690) {
                daylightTestPosition = daylightTestPosition.method_10084();
            }

            return brightnessAtEyes > 0.5F && field_5974.nextFloat() * 30.0F < (brightnessAtEyes - 0.4F) * 2.0F && field_6002.method_8311(daylightTestPosition);
        }

        return false;
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickTemperature(CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        class_1309 shape = PlayerShape.getCurrentShape(player);


        if (!player.method_7337() && !player.method_7325()) {
            // check if the player is morphed
            if (shape != null) {
                // damage player if they are a shape that gets hurt by low or high temperatures
                final boolean couldEnoughToSnow = field_6002.method_23753(method_24515()).comp_349().method_33599(method_24515());
                for (TemperatureTrait<?> temperaturetrait : TraitRegistry.get(shape, TemperatureTrait.ID).stream().map(entry -> (TemperatureTrait<?>) entry).toList()) {
                    if (!temperaturetrait.coldEnoughToSnow == couldEnoughToSnow) {
                        player.method_5643(class_1282.field_5854, 1.0f);
                        break;
                    }
                }
            }
        }
    }

    @Inject(method = "tick", at = @At("HEAD"))
    private void tickWalkers(CallbackInfo ci) {
        class_1657 player = (class_1657) (Object) this;
        class_1309 shape = PlayerShape.getCurrentShape(player);

        // assign basic data to entity from player on server; most data transferring
        // occurs on client
        if (shape != null) {
            shape.method_5660(player.method_5715());
            shape.method_18380(player.method_18376());
            shape.method_5796(player.method_5681());

            if (!field_6002.field_9236) {
                shape.method_23327(player.method_23317(), player.method_23318(), player.method_23321());
                shape.method_5847(player.method_5791());
                shape.method_6100(((LivingEntityAccessor) player).isJumping());
                shape.method_5728(player.method_5624());
                shape.method_6097(player.method_6022());
                shape.method_5684(true);
                shape.method_5875(true);
                shape.method_5796(player.method_5681());
                shape.method_6019(player.method_6058());

                if (shape instanceof class_1321) {
                    ((class_1321) shape).method_6179(player.method_5715());
                    ((class_1321) shape).method_24346(player.method_5715());
                } else if (shape instanceof class_4019) {
                    ((class_4019) shape).method_18294(player.method_5715());
                    ((class_4019) shape).method_6100(!player.method_24828());
                }

                ((EntityAccessor) shape).shape_callSetFlag(7, player.method_6128());

                ((LivingEntityAccessor) shape).callUpdatingUsingItem();
                PlayerShape.sync((class_3222) player); // safe cast - context is server world
            }
        }
    }

    @Inject(method = "makeStuckInBlock", at = @At("HEAD"), cancellable = true)
    private void onStuckInBlock(class_2680 state, class_243 motionMultiplier, CallbackInfo ci) {
        if (PlayerShape.getCurrentShape((class_1657) (Object) this) instanceof class_1628 && state.method_27852(class_2246.field_10343)) {
            ci.cancel();
        }
    }

    @Inject(method = "touch", at = @At("HEAD"))
    private void onTouch(class_1297 entity, CallbackInfo ci) {
        class_1657 ownPlayer = (class_1657) (Object) this;
        if (ownPlayer.method_5805() && PlayerShape.getCurrentShape(ownPlayer) instanceof class_1621 slimeShape && (entity instanceof class_1657 targetPlayer && !(PlayerShape.getCurrentShape(targetPlayer) instanceof class_1621))) {
            int i = slimeShape.method_7152();
            if (this.method_5858(targetPlayer) < 0.6 * (double) i * 0.6 * (double) i && ownPlayer.method_6057(targetPlayer) && targetPlayer.method_5643(class_1282.method_5511(ownPlayer), (float) ownPlayer.method_26825(class_5134.field_23721))) {
                this.method_5783(class_3417.field_14863, 1.0F, (this.field_5974.nextFloat() - this.field_5974.nextFloat()) * 0.2F + 1.0F);
                this.method_5723(ownPlayer, targetPlayer);
            }
        }
    }

    @Inject(method = "hurt", at = @At("HEAD"))
    private void handeReinforcementstrait(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1657 player = (class_1657) (Object) this;
        class_1309 shape = PlayerShape.getCurrentShape(player);
        if (source.method_5529() instanceof class_1309 livingAttacker && shape != null) {
            for (ReinforcementsTrait<class_1309> reinforcementTrait : TraitRegistry.get(shape, ReinforcementsTrait.ID).stream().map(trait -> (ReinforcementsTrait<class_1309>) trait).toList()) {
                double d = reinforcementTrait.getRange();
                class_238 aABB = class_238.method_29968(this.method_19538()).method_1009(d, 10.0, d);
                Iterator<? extends class_1309> var5 = this.field_6002.method_8390(class_1308.class, aABB, class_1301.field_6155.and(entity -> {
                    if (reinforcementTrait.hasReinforcements()) {
                        return reinforcementTrait.isReinforcement(entity);
                    } else {
                        return shape.getClass().isInstance(entity);
                    }
                })).iterator();

                while (true) {
                    class_1308 mob;
                    while (true) {
                        if (!var5.hasNext()) {
                            return;
                        }

                        mob = (class_1308) var5.next();
                        if (shape != mob && mob.method_5968() == null) {

                            boolean bl = false;

                            if (!bl) {
                                break;
                            }
                        }
                    }

                    mob.method_5980(livingAttacker);
                }
            }
        }
    }

    @Inject(method = "hurt", at = @At("HEAD"))
    private void instantDieOnDamageTypeTrait(class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1309 shape = PlayerShape.getCurrentShape((class_1657) (Object) this);
        if (shape != null) {
            for (ShapeTrait<class_1309> instantDieOnDamageTypetrait : TraitRegistry.get(shape, InstantDieOnDamageMsgTrait.ID)) {
                if (source.method_5525().equals(((InstantDieOnDamageMsgTrait<class_1309>) instantDieOnDamageTypetrait).msgId)) {
                    this.method_5768();
                }
            }
        }
    }

    @WrapWithCondition(method = "tick", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/food/FoodData;tick(Lnet/minecraft/world/entity/player/Player;)V"))
    private boolean preventFoodDataTick(class_1702 instance, class_1657 player) {
        class_1309 shape = PlayerShape.getCurrentShape(player);
        return player.method_6059(class_1294.field_5922) || !TraitRegistry.has(shape, AttackForHealthTrait.ID);
    }

    @Inject(method = "canEat", at = @At("RETURN"), cancellable = true)
    private void onCanEat(boolean canAlwaysEat, CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValue()) {
            if (TraitRegistry.has(PlayerShape.getCurrentShape((class_1657) (Object) this), AttackForHealthTrait.ID)) {
                cir.setReturnValue(false);
            }
        }
    }
}
