package tocraft.walkers.mixin.client;

import com.mojang.util.UUIDTypeAdapter;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_742;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.impl.PlayerDataProvider;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

@Environment(EnvType.CLIENT)
@Mixin(class_1297.class)
public abstract class ClientEntityMixin {
    @Inject(method = "getVehicle", at = @At("RETURN"), cancellable = true)
    private void getClientVehicle(CallbackInfoReturnable<class_1297> cir) {
        if ((Object) this instanceof class_742 clientPlayer && cir.getReturnValue() == null) {
            Optional<UUID> vehiclePlayerID = ((PlayerDataProvider) clientPlayer).walkers$getVehiclePlayerUUID();
            if (vehiclePlayerID.isPresent() && Objects.equals(UUIDTypeAdapter.fromString(class_310.method_1551().method_1548().method_1673()), vehiclePlayerID.get())) {
                cir.setReturnValue(class_310.method_1551().field_1724);
            }
        }
    }
}
