package tocraft.walkers.mixin;

import com.google.common.collect.ImmutableMap;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_4150;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;

@Mixin(class_4150.class)
public class VillagerHostilesSensorMixin {

    @Shadow
    @Final
    private static ImmutableMap<class_1299<?>, Float> ACCEPTABLE_DISTANCE_FROM_HOSTILES;

    @Inject(method = "isHostile", at = @At("HEAD"), cancellable = true)
    private void checkHostileWalkers(class_1309 entity, CallbackInfoReturnable<Boolean> cir) {
        if (entity instanceof class_1657 player) {
            // check if we should be performing this from config
            if (Walkers.CONFIG.villagersRunFrom2ndShapes) {
                class_1309 shape = PlayerShape.getCurrentShape(player);

                // check if shape is valid & if it is a type villagers run from
                if (shape != null && ACCEPTABLE_DISTANCE_FROM_HOSTILES.containsKey(shape.method_5864())) {
                    cir.setReturnValue(true);
                }
            }
        }
    }

    @SuppressWarnings("ConstantConditions")
    @Inject(method = "isClose", at = @At("HEAD"), cancellable = true)
    private void checkPlayerDanger(class_1309 villager, class_1309 potentialPlayer,
                                   CallbackInfoReturnable<Boolean> cir) {
        // should only be called if the above mixin passes, so we can assume the config
        // option is true
        if (potentialPlayer instanceof class_1657 player) {
            class_1309 shape = PlayerShape.getCurrentShape(player);

            // check if shape is valid & if it is a type villagers run from
            if (shape != null && ACCEPTABLE_DISTANCE_FROM_HOSTILES.containsKey(shape.method_5864())) {
                float f = ACCEPTABLE_DISTANCE_FROM_HOSTILES.get(shape.method_5864());
                cir.setReturnValue(potentialPlayer.method_5858(villager) <= (double) (f * f));
            } else {
                cir.setReturnValue(false);
            }
        }
    }
}
