package tocraft.walkers.mixin;

import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1321;
import net.minecraft.class_1338;
import net.minecraft.class_1355;
import net.minecraft.class_1400;
import net.minecraft.class_1657;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import tocraft.walkers.Walkers;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.FearedTrait;
import tocraft.walkers.traits.impl.PreyTrait;

@Mixin(class_1308.class)
public class MobHunterPreyMixin {
    @Shadow
    @Final
    protected class_1355 targetSelector;
    @Shadow
    @Final
    protected class_1355 goalSelector;

    @Unique
    private boolean walkers$registeredAttackPreyGoals = false;
    @Unique
    private boolean walkers$registeredAvoidHunterGoals = false;

    @Inject(method = "tick", at = @At("HEAD"))
    public void registerGoals(CallbackInfo ci) {
        if (!walkers$registeredAttackPreyGoals) {
            // ensure hunter can attack players with a shape similar to their normal prey
            if (!Walkers.CONFIG.hunterAttackAsPreyMorphedPlayer) {
                return;
            } else {
                targetSelector.method_6277(7,
                        new class_1400<>((class_1308) (Object) this, class_1657.class, 10, false, false, player -> {
                            // hunter should ignore players that look like their prey if they have an owner,
                            // unless the config option is turned to true
                            if (!Walkers.CONFIG.ownedHunterAttackAsPreyMorphedPlayer && (class_1308) (Object) this instanceof class_1321 tamableAnimal && tamableAnimal.method_6177() != null) {
                                return false;
                            }

                            class_1309 shape = PlayerShape.getCurrentShape((class_1657) player);

                            if (shape != null) {
                                for (PreyTrait<?> preyTrait : TraitRegistry.get(shape, PreyTrait.ID).stream().map(entry -> (PreyTrait<?>) entry).toList()) {
                                    if (preyTrait.isHunter((class_1308) (Object) this)) return true;
                                }
                            }

                            return false;
                        }));
            }

            walkers$registeredAttackPreyGoals = true;
        }

        if (!walkers$registeredAvoidHunterGoals && (Object) this instanceof class_1314 mob) {
            goalSelector.method_6277(3, new class_1338<>(
                    mob,
                    class_1657.class,
                    player -> {
                        class_1309 shape = PlayerShape.getCurrentShape((class_1657) player);
                        if (shape != null) {
                            for (FearedTrait<?> fearedTrait : TraitRegistry.get(shape, FearedTrait.ID).stream().map(entry -> (FearedTrait<?>) entry).toList()) {
                                if (fearedTrait.isFeared(mob)) {
                                    return true;
                                }
                            }
                        }
                        return false;

                    },
                    6.0F,
                    1.0D,
                    1.2D,
                    player -> true
            ));
            walkers$registeredAvoidHunterGoals = true;
        }
    }
}
