package tocraft.walkers.mixin;

import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1338;
import net.minecraft.class_1451;
import net.minecraft.class_1463;
import net.minecraft.class_1657;
import net.minecraft.class_3701;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import tocraft.walkers.api.PlayerShape;

@Mixin(class_1338.class)
public class AvoidEntityGoalMixin<T extends class_1309> {
    @Shadow
    protected T toAvoid;
    @Final
    @Shadow
    protected class_1314 mob;

    @Inject(method = "canUse", at = @At("RETURN"), cancellable = true)
    private void onCanUse(CallbackInfoReturnable<Boolean> cir) {
        if (cir.getReturnValue() && this.toAvoid instanceof class_1657 player) {
            // prevent cats and ocelots to run from cats and ocelots
            if (this.mob instanceof class_1451 || this.mob instanceof class_3701) {
                if (PlayerShape.getCurrentShape(player) instanceof class_3701 || PlayerShape.getCurrentShape(player) instanceof class_1451) {
                    cir.setReturnValue(false);
                }
            }
            // prevent rabbits to run from rabbits
            else if (this.mob instanceof class_1463) {
                if (PlayerShape.getCurrentShape(player) instanceof class_1463) {
                    cir.setReturnValue(false);
                }
            }
        }
    }
}
