package tocraft.walkers.impl.variant;

import com.google.common.collect.ImmutableMap;
import tocraft.walkers.api.variant.TypeProvider;

import java.util.Map;
import net.minecraft.class_1299;
import net.minecraft.class_1463;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_5250;

public class RabbitTypeProvider extends TypeProvider<class_1463> {

    private static final Map<Integer, String> PREFIX_BY_ID = ImmutableMap
            .<Integer, String>builder()
            .put(0, "Brown")
            .put(1, "White")
            .put(2, "Black")
            .put(3, "White Splotched")
            .put(4, "Gold")
            .put(5, "Salt")
            .put(6, "Evil")
            .build();

    @Override
    public int getVariantData(class_1463 entity) {
        int id = entity.method_6610();
        if (id == 99) return 6;
        else return id;
    }

    @Override
    public class_1463 create(class_1299<class_1463> type, class_1937 level, int data) {
        class_1463 rabbit = new class_1463(type, level);
        if (data == 6) data = 99;
        rabbit.method_6617(data);
        return rabbit;
    }

    @Override
    public int getFallbackData() {
        return 0;
    }

    @Override
    public int getRange() {
        return 6;
    }

    @Override
    public class_2561 modifyText(class_1463 entity, class_5250 text) {
        int variant = getVariantData(entity);
        return new class_2585(PREFIX_BY_ID.containsKey(variant) ? PREFIX_BY_ID.get(variant) + " " : "").method_10852(text);
    }
}