package tocraft.walkers.eventhandler;

import net.minecraft.class_1309;
import net.minecraft.class_1657;
import tocraft.craftedcore.event.common.EntityEvents;
import tocraft.walkers.api.PlayerShape;
import tocraft.walkers.traits.TraitRegistry;
import tocraft.walkers.traits.impl.AquaticTrait;
import tocraft.walkers.traits.impl.UndrownableTrait;

public final class LivingBreatheHandler implements EntityEvents.LivingBreathe {
    @Override
    public boolean breathe(class_1309 entity, boolean canBreathe) {
        if (entity instanceof class_1657) {
            class_1309 shape = PlayerShape.getCurrentShape((class_1657) entity);

            if (shape != null) {
                boolean isInWater = entity.method_5816();

                for (AquaticTrait<class_1309> trait : TraitRegistry.get(shape, AquaticTrait.ID).stream().map(trait -> (AquaticTrait<class_1309>) trait).toList()) {
                    return isInWater ? trait.isAquatic : trait.isLand;
                }

                if (TraitRegistry.has(shape, UndrownableTrait.ID) || shape.method_6094() && isInWater) {
                    return true;
                }

            }
        }
        return canBreathe;
    }
}
