package tocraft.walkers.command;

import com.mojang.brigadier.tree.LiteralCommandNode;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2188;
import net.minecraft.class_2321;
import net.minecraft.class_2378;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import tocraft.walkers.Walkers;

public class EntityBlacklistCommands {
    public static LiteralCommandNode<class_2168> getRootNode() {
        LiteralCommandNode<class_2168> rootNode = class_2170.method_9247("entityBlacklist").build();

        LiteralCommandNode<class_2168> addToList = class_2170.method_9247("add")
                .then(class_2170.method_9244("entity", class_2188.method_9324()).suggests(class_2321.field_10935)
                        .executes(context -> {
                            addToList(context.getSource(), class_2378.field_11145.method_10223(class_2188.method_9322(context, "entity")));
                            return 1;
                        }))
                .build();
        LiteralCommandNode<class_2168> removeFromList = class_2170.method_9247("remove")
                .then(class_2170.method_9244("entity", class_2188.method_9324()).suggests(class_2321.field_10935)
                        .executes(context -> {
                            removeFromList(context.getSource(), class_2378.field_11145.method_10223(class_2188.method_9322(context, "entity")));
                            return 1;
                        }))
                .build();

        LiteralCommandNode<class_2168> listList = class_2170.method_9247("list")
                .executes(context -> listEntities(context.getSource()))
                .build();

        LiteralCommandNode<class_2168> clearList = class_2170.method_9247("clear")
                .executes(context -> clearEntities(context.getSource()))
                .build();

        rootNode.addChild(listList);
        rootNode.addChild(clearList);
        rootNode.addChild(addToList);
        rootNode.addChild(removeFromList);
        return rootNode;
    }

    private static int clearEntities(class_2168 source) {
        Walkers.CONFIG.entityBlacklist.clear();
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        source.method_9226(new class_2588("walkers.entityBlacklist.clear"), true);

        return 1;
    }

    private static int listEntities(class_2168 source) {
        for (String s : Walkers.CONFIG.entityBlacklist) {
            source.method_9226(new class_2588("walkers.entityBlacklist.list", s), true);
        }

        if (Walkers.CONFIG.entityBlacklist.isEmpty()) {
            source.method_9226(new class_2588("walkers.entityBlacklist.isEmpty"), true);
        }

        return 1;
    }

    private static void addToList(class_2168 source, class_1299<?> type) {
        Walkers.CONFIG.entityBlacklist.add(class_1299.method_5890(type).toString());
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        source.method_9226(new class_2588("walkers.entityBlacklist.add", class_1299.method_5890(type).toString()), true);
    }

    private static void removeFromList(class_2168 source, class_1299<?> type) {
        Walkers.CONFIG.entityBlacklist.remove(class_1299.method_5890(type).toString());
        Walkers.CONFIG.save();

        for (class_3222 player : source.method_9211().method_3760().method_14571()) {
            Walkers.CONFIG.sendToPlayer(player);
        }

        source.method_9226(new class_2588("walkers.entityBlacklist.remove", class_1299.method_5890(type).toString()), true);
    }
}
