package tocraft.walkers.api.model.impl;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1309;
import net.minecraft.class_2378;
import net.minecraft.class_310;
import net.minecraft.class_5601;
import net.minecraft.class_583;
import net.minecraft.class_630;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tocraft.walkers.api.model.ClassArmProvider;

@SuppressWarnings("unused")
@Environment(EnvType.CLIENT)
public class GenericEntityArm<L extends class_1309, T extends class_583<L>> implements ClassArmProvider<T> {

    public GenericEntityArm() {
        this((class_5601) null, "right_front_leg");
    }

    public GenericEntityArm(@NotNull class_5601 modelLayerLocation) {
        this(modelLayerLocation, "right_front_leg");
    }

    /**
     * @param modelParts the model parts in the order they appear - e.g. ["root", "body", "right_arm"]
     */
    public GenericEntityArm(@NotNull String... modelParts) {
        this(null, modelParts);
    }

    public GenericEntityArm(@Nullable class_5601 modelLayerLocation, @NotNull String... modelParts) {
        this.modelLayerLocation = modelLayerLocation;
        this.modelParts = modelParts;
    }

    @Nullable
    private final class_5601 modelLayerLocation;
    @NotNull
    private final String[] modelParts;

    @Override
    public class_630 getArm(class_1309 entity, T model) {
        class_5601 modelLayer = modelLayerLocation != null ? modelLayerLocation : new class_5601(class_2378.field_11145.method_10221(entity.method_5864()), "main");
        class_630 modelPart = class_310.method_1551().method_31974().method_32072(modelLayer);
        for (String part : modelParts) {
            modelPart = modelPart.method_32086(part);
        }
        return modelPart;
    }
}
