package tocraft.walkers.api.blacklist;

import tocraft.walkers.Walkers;
import tocraft.walkers.integrations.Integrations;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_6862;

public class EntityBlacklist {
    private static final List<class_1299<?>> typeBlacklist = new ArrayList<>();
    private static final List<class_6862<class_1299<?>>> tagBlacklist = new ArrayList<>();

    public static void registerDefault() {
        // support deprecated entity tags
        registerByTag(class_6862.method_40092(class_2378.field_25107, Walkers.id("blacklisted")));

        // handle Integrations
        Integrations.registerEntityBlacklist();
    }

    public static boolean isBlacklisted(class_1299<?> entityType) {
        if (typeBlacklist.contains(entityType)) return true;
        for (class_6862<class_1299<?>> entityTypeTagKey : tagBlacklist) {
            if (entityType.method_20210(entityTypeTagKey)) return true;
        }
        return Walkers.CONFIG.entityBlacklist.contains(class_1299.method_5890(entityType).toString());
    }

    public static void registerByType(class_1299<?> entityType) {
        if (!typeBlacklist.contains(entityType)) typeBlacklist.add(entityType);
    }

    public static void registerByTag(class_6862<class_1299<?>> entityTypeTag) {
        if (!tagBlacklist.contains(entityTypeTag)) tagBlacklist.add(entityTypeTag);
    }

    public static void clearAll() {
        typeBlacklist.clear();
        tagBlacklist.clear();
    }
}
